/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.ui.html.UiSession;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class ResponseHistory {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseHistory.class);
    private static final int MAX_RESPONSE_HISTORY_SIZE = 10;
    private final Object m_mutex = new Object();
    private final Map<Long, Long> m_requestToResponseMap = new HashMap<Long, Long>();
    private final Map<Long, Long> m_responseToRequestMap = new HashMap<Long, Long>();
    private final SortedMap<Long, JSONObject> m_responses = new TreeMap<Long, JSONObject>();
    private UiSession m_uiSession;

    public UiSession getUiSession() {
        return this.m_uiSession;
    }

    public ResponseHistory withUiSession(UiSession uiSession) {
        this.m_uiSession = uiSession;
        return this;
    }

    protected String getUiSessionId() {
        return this.m_uiSession == null ? null : this.m_uiSession.getUiSessionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResponse(Long responseSequenceNo, JSONObject response, Long requestSequenceNo) {
        Assertions.assertNotNull((Object)responseSequenceNo);
        Assertions.assertNotNull((Object)response);
        Object object = this.m_mutex;
        synchronized (object) {
            Assertions.assertFalse((boolean)this.m_responses.containsKey(responseSequenceNo), (String)"ResponseSequenceNo #{} already registered", (Object[])new Object[]{responseSequenceNo});
            if (requestSequenceNo != null) {
                Assertions.assertFalse((boolean)this.m_requestToResponseMap.containsKey(requestSequenceNo), (String)"RequestSequenceNo #{} already registered", (Object[])new Object[]{requestSequenceNo});
                Assertions.assertFalse((boolean)this.m_responseToRequestMap.containsKey(responseSequenceNo), (String)"ResponseSequenceNo #{} already registered", (Object[])new Object[]{responseSequenceNo});
            }
            this.m_responses.put(responseSequenceNo, response);
            if (requestSequenceNo != null) {
                this.m_requestToResponseMap.put(requestSequenceNo, responseSequenceNo);
                this.m_responseToRequestMap.put(responseSequenceNo, requestSequenceNo);
            }
            if (this.m_responses.size() > 10) {
                Long oldestSeqNo = this.m_responses.firstKey();
                LOG.warn("Max. response history size exceeded for UI session {}, dropping oldest response #{}", (Object)this.getUiSessionId(), (Object)oldestSeqNo);
                this.m_responses.remove(oldestSeqNo);
            }
            LOG.debug("Added response #{} to history {} for UI session {}", new Object[]{responseSequenceNo, this.m_responses.keySet(), this.getUiSessionId()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmResponseProcessed(Long confirmedResponseSequenceNo) {
        Assertions.assertNotNull((Object)confirmedResponseSequenceNo);
        Object object = this.m_mutex;
        synchronized (object) {
            int removeCount = 0;
            Iterator<Long> it = this.m_responses.keySet().iterator();
            while (it.hasNext()) {
                Long responseSequenceNo = it.next();
                if (responseSequenceNo > confirmedResponseSequenceNo) continue;
                Long requestSequenceNo = this.m_responseToRequestMap.get(responseSequenceNo);
                this.m_requestToResponseMap.remove(requestSequenceNo);
                this.m_responseToRequestMap.remove(responseSequenceNo);
                it.remove();
                ++removeCount;
            }
            LOG.debug("Cleaned up response history (-{}). New content: {} [#ACK={}, uiSessionId={}]", new Object[]{removeCount, this.m_responses.keySet(), confirmedResponseSequenceNo, this.getUiSessionId()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject toSyncResponse() {
        Object object = this.m_mutex;
        synchronized (object) {
            block8: {
                LOG.debug("Synchronize response queue {} for UI session {}", this.m_responses.keySet(), (Object)this.getUiSessionId());
                if (!this.m_responses.isEmpty()) break block8;
                return null;
            }
            Long lastSentSequenceNo = this.m_responses.lastKey();
            JSONObject combinedAdapterData = new JSONObject();
            JSONArray combinedEvents = new JSONArray();
            for (JSONObject response : this.m_responses.values()) {
                JSONArray events;
                JSONObject adapterData = response.optJSONObject("adapterData");
                if (adapterData != null) {
                    for (String key : adapterData.keySet()) {
                        combinedAdapterData.put(key, adapterData.get(key));
                    }
                }
                if ((events = response.optJSONArray("events")) == null) continue;
                int i = 0;
                while (i < events.length()) {
                    combinedEvents.put(events.get(i));
                    ++i;
                }
            }
            JSONObject combinedResponse = new JSONObject();
            combinedResponse.put("#", (Object)lastSentSequenceNo);
            combinedResponse.put("combined", true);
            combinedResponse.put("adapterData", (Object)(combinedAdapterData.length() == 0 ? null : combinedAdapterData));
            combinedResponse.put("events", (Object)(combinedEvents.length() == 0 ? null : combinedEvents));
            return combinedResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getResponseSequenceNo(Long requestSequenceNo) {
        if (requestSequenceNo == null) {
            return null;
        }
        Object object = this.m_mutex;
        synchronized (object) {
            return this.m_requestToResponseMap.get(requestSequenceNo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getRequestSequenceNo(Long responseSequenceNo) {
        if (responseSequenceNo == null) {
            return null;
        }
        Object object = this.m_mutex;
        synchronized (object) {
            return this.m_responseToRequestMap.get(responseSequenceNo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getResponse(Long responseSequenceNo) {
        if (responseSequenceNo == null) {
            return null;
        }
        Object object = this.m_mutex;
        synchronized (object) {
            return (JSONObject)this.m_responses.get(responseSequenceNo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getResponseForRequest(Long requestSequenceNo) {
        Object object = this.m_mutex;
        synchronized (object) {
            return this.getResponse(this.getResponseSequenceNo(requestSequenceNo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.m_mutex;
        synchronized (object) {
            return this.m_responses.size();
        }
    }

    public String toString() {
        return "[" + CollectionUtility.format(this.m_responses.keySet()) + "]";
    }
}

