/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.AbstractConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractPositiveIntegerConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractPositiveLongConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractStringConfigProperty;
import org.eclipse.scout.rt.platform.util.StringUtility;

public final class UiHtmlConfigProperties {
    private UiHtmlConfigProperties() {
    }

    public static class BackgroundPollingIntervalProperty
    extends AbstractPositiveLongConfigProperty {
        public Long getDefaultValue() {
            return TimeUnit.SECONDS.toSeconds(60L);
        }

        public String description() {
            return String.format("The polling request (which waits for a background job to complete) stays open until a background job has completed or the specified number of seconds elapsed.\nThis property must have a value between 3 and the value of property '%s'.\nBy default this property is set to 1 minute.", ((MaxUserIdleTimeProperty)((Object)BEANS.get(MaxUserIdleTimeProperty.class))).getKey());
        }

        public String getKey() {
            return "scout.ui.backgroundPollingMaxWaitTime";
        }
    }

    public static class MaxUserIdleTimeProperty
    extends AbstractPositiveLongConfigProperty {
        public Long getDefaultValue() {
            return TimeUnit.HOURS.toSeconds(4L);
        }

        public String description() {
            return "If a user is inactive (no user action) for the specified number of seconds, the session is stopped and the user is logged out.\nBy default this property is set to 4 hours.";
        }

        public String getKey() {
            return "scout.ui.maxUserIdleTime";
        }
    }

    public static class SessionStoreHousekeepingDelayProperty
    extends AbstractPositiveIntegerConfigProperty {
        public String getKey() {
            return "scout.ui.sessionstore.housekeepingDelay";
        }

        public String description() {
            return "Number of seconds before the housekeeping job starts after a UI session has been unregistered from the store.\nBy default this property is set to 30 seconds.";
        }

        public Integer getDefaultValue() {
            return 30;
        }
    }

    public static class UiLocalesProperty
    extends AbstractConfigProperty<List<String>, String> {
        public String getKey() {
            return "scout.ui.locales";
        }

        protected List<String> parse(String value) {
            String[] tokens = StringUtility.tokenize((String)value, (char)',');
            return Collections.unmodifiableList(Arrays.asList(tokens));
        }

        public String description() {
            return "Contains a comma separated list of supported locales (e.g. en,en-US,de-CH). To support all locales, use the keyword 'all' instead.\nThis is only relevant if locales.json and texts.json should be sent to the client, which is not the case for remote apps. So this property is only used for JS only apps.\nBy default no locales are supported.";
        }

        public List<String> getDefaultValue() {
            return Collections.emptyList();
        }
    }

    public static class UiModelJobsAwaitTimeoutProperty
    extends AbstractPositiveLongConfigProperty {
        public Long getDefaultValue() {
            return TimeUnit.HOURS.toSeconds(1L);
        }

        public String description() {
            return "The maximal timeout in seconds to wait for model jobs to complete during a UI request. After that timeout the model jobs will be aborted so that the request may return to the client.\nBy default this property is set to 1 hour.";
        }

        public String getKey() {
            return "scout.ui.modelJobTimeout";
        }
    }

    public static class UiThemeProperty
    extends AbstractStringConfigProperty {
        public static final String DEFAULT_THEME = "default";

        public String getKey() {
            return "scout.ui.theme";
        }

        public String description() {
            return "The name of the UI theme which is activated when the application starts.";
        }

        public String getDefaultValue() {
            return DEFAULT_THEME;
        }
    }
}

