/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html;

import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.job.filter.future.ModelJobFutureFilter;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxes;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.filter.AndFilter;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.JobState;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.job.filter.future.FutureFilter;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.platform.util.concurrent.TimedOutError;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.job.filter.future.SessionFutureFilter;
import org.eclipse.scout.rt.ui.html.UiHtmlConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class UiJobs {
    private static final Logger LOG = LoggerFactory.getLogger(UiJobs.class);
    public static final String EXECUTION_HINT_POLL_REQUEST = String.valueOf(UiJobs.class.getName()) + ".pollRequest";
    public static final String EXECUTION_HINT_RESPONSE_TO_JSON = String.valueOf(UiJobs.class.getName()) + ".responseToJson";
    private final long m_awaitTimeout = (Long)CONFIG.getPropertyValue(UiHtmlConfigProperties.UiModelJobsAwaitTimeoutProperty.class);

    public void awaitModelJobs(IClientSession clientSession, Class<? extends ExceptionHandler> exceptionHandler) {
        Assertions.assertNotNull((Object)clientSession, (String)"'ClientSession' must not be null", (Object[])new Object[0]);
        try {
            this.await((Predicate<IFuture<?>>)new AndFilter(new Predicate[]{ModelJobFutureFilter.INSTANCE, new SessionFutureFilter((ISession)clientSession)}));
        }
        catch (ThreadInterruptedError e) {
            ClientRunContexts.copyCurrent().withSession(clientSession, true).run(() -> ((ExceptionHandler)BEANS.get((Class)exceptionHandler)).handle((Throwable)e));
        }
        catch (TimedOutError e) {
            this.handleAwaitModelJobsTimedOutError(clientSession, exceptionHandler, e);
        }
    }

    protected void handleAwaitModelJobsTimedOutError(IClientSession clientSession, Class<? extends ExceptionHandler> exceptionHandler, TimedOutError e) {
        LOG.warn("Timeout while waiting for model jobs to finish, cancelling running and scheduled model jobs.");
        this.cancelModelJobs(clientSession);
        ModelJobs.schedule(() -> ((IMessageBox)MessageBoxes.createOk().withHeader(TEXTS.get((String)"ui.RequestTimeout")).withBody(TEXTS.get((String)"ui.RequestTimeoutMsg")).withSeverity(0x1000000)).show(), (JobInput)ModelJobs.newInput((ClientRunContext)ClientRunContexts.copyCurrent().withSession(clientSession, true)).withName("Handling await model jobs timeout", new Object[0]));
    }

    public void cancelModelJobs(IClientSession clientSession) {
        Jobs.getJobManager().cancel(ModelJobs.newFutureFilterBuilder().andMatch((Predicate)new SessionFutureFilter((ISession)clientSession)).andMatchNotExecutionHint(EXECUTION_HINT_RESPONSE_TO_JSON).andMatchNotExecutionHint(EXECUTION_HINT_POLL_REQUEST).andMatchNotExecutionHint("ui.interaction.required").andMatchNotExecutionHint("not.cancellable.by.user").toFilter(), true);
    }

    public <RESULT> RESULT awaitAndGet(IFuture<RESULT> future) {
        this.await((Predicate<IFuture<?>>)new FutureFilter(new IFuture[]{future}));
        if (future.containsExecutionHint("ui.interaction.required")) {
            return null;
        }
        return (RESULT)future.awaitDoneAndGet();
    }

    public void await(Predicate<IFuture<?>> filter) {
        Jobs.getJobManager().awaitDone(Jobs.newFutureFilterBuilder().andMatchNotExecutionHint("ui.interaction.required").andAreSingleExecuting().andMatchNotState(new JobState[]{JobState.NEW}).andMatchNotState(new JobState[]{JobState.PENDING}).andMatch(filter).toFilter(), this.getAwaitTimeout(), TimeUnit.SECONDS);
    }

    protected long getAwaitTimeout() {
        return this.m_awaitTimeout;
    }
}

