/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html;

import java.security.AccessController;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import javax.security.auth.Subject;
import javax.servlet.SessionCookieConfig;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.IDesktopUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.ValidationFailedStatus;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.context.PropertyMap;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.JobState;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.job.listener.JobEvent;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.IRegistrationHandle;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.concurrent.FutureCancelledError;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.server.commons.servlet.CookieUtility;
import org.eclipse.scout.rt.server.commons.servlet.HttpClientInfo;
import org.eclipse.scout.rt.server.commons.servlet.UrlHints;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpResourceCache;
import org.eclipse.scout.rt.server.commons.servlet.cache.IHttpResourceCache;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.job.filter.event.SessionJobEventFilter;
import org.eclipse.scout.rt.shared.session.Sessions;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;
import org.eclipse.scout.rt.shared.ui.UiLayer;
import org.eclipse.scout.rt.shared.ui.UiSystem;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.shared.ui.UserAgents;
import org.eclipse.scout.rt.ui.html.HttpSessionHelper;
import org.eclipse.scout.rt.ui.html.ISessionStore;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.IUiTextContributor;
import org.eclipse.scout.rt.ui.html.RequestHistory;
import org.eclipse.scout.rt.ui.html.ResponseHistory;
import org.eclipse.scout.rt.ui.html.UiException;
import org.eclipse.scout.rt.ui.html.UiHtmlConfigProperties;
import org.eclipse.scout.rt.ui.html.UiJobs;
import org.eclipse.scout.rt.ui.html.UiSessionEvent;
import org.eclipse.scout.rt.ui.html.UiSessionListeners;
import org.eclipse.scout.rt.ui.html.UiThemeHelper;
import org.eclipse.scout.rt.ui.html.UiThreadInterruption;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonAdapterRegistry;
import org.eclipse.scout.rt.ui.html.json.JsonClientSession;
import org.eclipse.scout.rt.ui.html.json.JsonEventProcessor;
import org.eclipse.scout.rt.ui.html.json.JsonLocale;
import org.eclipse.scout.rt.ui.html.json.JsonRequest;
import org.eclipse.scout.rt.ui.html.json.JsonRequestHelper;
import org.eclipse.scout.rt.ui.html.json.JsonResponse;
import org.eclipse.scout.rt.ui.html.json.JsonStartupRequest;
import org.eclipse.scout.rt.ui.html.json.MainJsonObjectFactory;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonFormField;
import org.eclipse.scout.rt.ui.html.management.SessionMonitorMBean;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceConsumer;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceUploader;
import org.eclipse.scout.rt.ui.html.res.IUploadable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiSession
implements IUiSession {
    private static final Logger LOG = LoggerFactory.getLogger(UiSession.class);
    private static final long ROOT_ID = 1L;
    private static final String EVENT_LOCALE_CHANGED = "localeChanged";
    private static final String EVENT_DISPOSE_ADAPTER = "disposeAdapter";
    private static final String EVENT_RELOAD_PAGE = "reloadPage";
    private static final long ADDITIONAL_POLLING_DELAY = 100L;
    private static final LazyValue<HttpSessionHelper> HTTP_SESSION_HELPER = new LazyValue(HttpSessionHelper.class);
    private static final LazyValue<JsonRequestHelper> JSON_REQUEST_HELPER = new LazyValue(JsonRequestHelper.class);
    private static final String URL_PARAM_THEME = "theme";
    private final JsonAdapterRegistry m_jsonAdapterRegistry;
    private final JsonEventProcessor m_jsonEventProcessor;
    private final P_RootAdapter m_rootJsonAdapter;
    private final AtomicLong m_jsonAdapterSeq = new AtomicLong(1L);
    private final AtomicLong m_responseSequenceNo = new AtomicLong(1L);
    private final RequestHistory m_requestHistory = ((RequestHistory)BEANS.get(RequestHistory.class)).withUiSession(this);
    private final ResponseHistory m_responseHistory = ((ResponseHistory)BEANS.get(ResponseHistory.class)).withUiSession(this);
    private final ReentrantLock m_uiSessionLock = new ReentrantLock();
    private final HttpContext m_httpContext = new HttpContext();
    private final BlockingQueue<Object> m_pollerQueue = new ArrayBlockingQueue<Object>(1, true);
    private final Object m_pollerQueueLock = new Object();
    private final Object m_notificationToken = new Object();
    private final IHttpResourceCache m_httpResourceCache = (IHttpResourceCache)BEANS.get(HttpResourceCache.class);
    private final UiSessionListeners m_listeners = new UiSessionListeners();
    private volatile boolean m_initialized;
    private volatile ISessionStore m_sessionStore;
    private volatile String m_uiSessionId;
    private volatile IClientSession m_clientSession;
    private volatile JsonResponse m_currentJsonResponse;
    private volatile JsonRequest m_currentJsonRequest;
    private volatile boolean m_processingJsonRequest;
    private volatile boolean m_attachedToDesktop;
    private volatile boolean m_disposing;
    private volatile boolean m_disposed;
    private volatile IRegistrationHandle m_uiDataAvailableListener;
    private volatile long m_lastAccessedTime;
    private volatile RunMonitor m_pollerMonitor;
    private volatile boolean m_persistent;

    public UiSession() {
        this.m_jsonAdapterRegistry = this.createJsonAdapterRegistry();
        this.m_jsonEventProcessor = this.createJsonEventProcessor();
        this.m_rootJsonAdapter = new P_RootAdapter(this);
    }

    protected JsonAdapterRegistry createJsonAdapterRegistry() {
        return new JsonAdapterRegistry();
    }

    protected final JsonAdapterRegistry jsonAdapterRegistry() {
        return this.m_jsonAdapterRegistry;
    }

    protected JsonEventProcessor createJsonEventProcessor() {
        return new JsonEventProcessor(this);
    }

    protected final JsonEventProcessor jsonEventProcessor() {
        return this.m_jsonEventProcessor;
    }

    protected final AtomicLong jsonAdapterSeq() {
        return this.m_jsonAdapterSeq;
    }

    protected final AtomicLong responseSequenceNo() {
        return this.m_responseSequenceNo;
    }

    @Override
    public ReentrantLock uiSessionLock() {
        return this.m_uiSessionLock;
    }

    protected final HttpContext httpContext() {
        return this.m_httpContext;
    }

    protected final BlockingQueue<Object> pollerQueue() {
        return this.m_pollerQueue;
    }

    protected final Object notificationToken() {
        return this.m_notificationToken;
    }

    protected final RunMonitor pollerMonitor() {
        return this.m_pollerMonitor;
    }

    @Override
    public void init(HttpServletRequest req, HttpServletResponse resp, JsonStartupRequest jsonStartupReq) {
        if (this.currentSubject() == null) {
            throw new SecurityException("/json request is not authenticated with a Subject");
        }
        if (this.m_initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.m_initialized = true;
        this.touch();
        try {
            ((SessionMonitorMBean)BEANS.get(SessionMonitorMBean.class)).weakRegister(this);
            this.m_httpContext.set(req, resp);
            this.m_currentJsonRequest = jsonStartupReq;
            HttpSession httpSession = req.getSession();
            this.m_currentJsonResponse = this.createJsonStartupResponse();
            this.setUiSessionIdInternal(this.createUiSessionId(jsonStartupReq));
            this.m_currentJsonResponse.getStartupData().put("uiSessionId", (Object)this.getUiSessionId());
            this.m_sessionStore = UiSession.getHttpSessionHelper().getSessionStore(httpSession);
            this.m_clientSession = this.getOrCreateClientSession(httpSession, req, jsonStartupReq);
            this.storePreferredLocaleInCookie(resp, this.m_clientSession.getLocale());
            this.storeHttpSessionIdInCookie(resp, httpSession, this.m_clientSession.getUserAgent());
            boolean reloadPage = this.initUiTheme(req, resp, jsonStartupReq.getSessionStartupParams());
            if (reloadPage) {
                this.putReloadPageStartupData();
                LOG.info("Requested page reload for new UiSession with ID {}", (Object)this.getUiSessionId());
                return;
            }
            try {
                this.installUiDataAvailableListener(this.m_clientSession);
                this.startDesktop(jsonStartupReq.getSessionStartupParams());
                JsonClientSession<?> jsonClientSessionAdapter = this.createClientSessionAdapter(this.m_clientSession);
                this.putInitializationStartupData(jsonClientSessionAdapter.getId());
                this.putUrlHintsStartupData();
                LOG.info("UiSession with ID {} initialized", (Object)this.m_uiSessionId);
            }
            catch (RuntimeException | PlatformError e) {
                this.dispose();
                throw e;
            }
        }
        finally {
            this.m_httpContext.clear();
            this.m_currentJsonRequest = null;
        }
    }

    protected JsonResponse createJsonResponse() {
        return new JsonResponse(this.m_responseSequenceNo.getAndIncrement());
    }

    protected JsonResponse createJsonStartupResponse() {
        JsonResponse response = new JsonResponse();
        response.markAsStartupResponse();
        return response;
    }

    protected String createUiSessionId(JsonStartupRequest jsonStartupReq) {
        return String.valueOf(jsonStartupReq.getPartId()) + ':' + Sessions.randomSessionId();
    }

    protected IClientSession getOrCreateClientSession(HttpSession httpSession, HttpServletRequest req, JsonStartupRequest jsonStartupReq) {
        String requestedClientSessionId = jsonStartupReq.getClientSessionId();
        IClientSession clientSession = this.sessionStore().preregisterUiSession(this, requestedClientSessionId);
        if (clientSession != null) {
            LOG.info("Using cached client session [clientSessionId={}]", (Object)clientSession.getId());
            return clientSession;
        }
        clientSession = this.createAndStartClientSession(req.getLocale(), this.createUserAgent(jsonStartupReq), jsonStartupReq.getSessionStartupParams());
        LOG.info("Created new client session [clientSessionId={}, userAgent={}]", (Object)clientSession.getId(), (Object)clientSession.getUserAgent());
        ((SessionMonitorMBean)BEANS.get(SessionMonitorMBean.class)).weakRegister(clientSession);
        if (!clientSession.isActive()) {
            throw new UiException("ClientSession is not active, there must have been a problem with loading or starting [clientSessionId=" + clientSession.getId() + "]");
        }
        return clientSession;
    }

    protected UserAgent createUserAgent(JsonStartupRequest jsonStartupReq) {
        HttpClientInfo httpClientInfo = HttpClientInfo.get((HttpServletRequest)this.currentHttpRequest());
        UserAgents userAgentBuilder = httpClientInfo.toUserAgents();
        JSONObject userAgent = jsonStartupReq.getUserAgent();
        if (userAgent != null) {
            String uiLayerStr;
            String uiDeviceTypeStr = userAgent.optString("deviceType", null);
            if (uiDeviceTypeStr != null) {
                userAgentBuilder.withUiDeviceType(UiDeviceType.createByIdentifier((String)uiDeviceTypeStr));
            }
            if ((uiLayerStr = userAgent.optString("uiLayer", null)) != null) {
                userAgentBuilder.withUiLayer(UiLayer.createByIdentifier((String)uiLayerStr));
            }
            boolean touch = userAgent.optBoolean("touch", false);
            userAgentBuilder.withTouch(touch);
            boolean standalone = userAgent.optBoolean("standalone", false);
            userAgentBuilder.withStandalone(standalone);
        }
        return userAgentBuilder.build();
    }

    protected IClientSession createAndStartClientSession(Locale locale, UserAgent userAgent, Map<String, String> sessionStartupParams) {
        return ((ClientSessionProvider)BEANS.get(ClientSessionProvider.class)).provide(ClientRunContexts.copyCurrent().withLocale(locale).withUserAgent(userAgent).withProperties(sessionStartupParams));
    }

    protected void storePreferredLocaleInCookie(HttpServletResponse resp, Locale locale) {
        CookieUtility.addPersistentCookie((HttpServletResponse)resp, (String)"scout.preferredLocale", (String)locale.toLanguageTag());
    }

    protected void storeHttpSessionIdInCookie(HttpServletResponse resp, HttpSession httpSession, UserAgent userAgent) {
        if (!userAgent.getUiSystem().equals(UiSystem.IOS) || !userAgent.isStandalone()) {
            return;
        }
        SessionCookieConfig cookieConfig = httpSession.getServletContext().getSessionCookieConfig();
        if (cookieConfig.getMaxAge() > 0) {
            LOG.info("Using persistent session cookie from container, maxAge is {} s", (Object)cookieConfig.getMaxAge());
        } else {
            Cookie cookie = this.createPersistentSessionCookie(cookieConfig, httpSession);
            resp.addCookie(cookie);
            LOG.info("Created persistent session cookie, maxAge is {} s", (Object)cookie.getMaxAge());
        }
        this.m_persistent = true;
    }

    protected Cookie createPersistentSessionCookie(SessionCookieConfig config, HttpSession httpSession) {
        Cookie cookie = new Cookie((String)ObjectUtility.nvl((Object)config.getName(), (Object)"JSESSIONID"), httpSession.getId());
        cookie.setMaxAge((int)TimeUnit.DAYS.toSeconds(365L));
        cookie.setComment(config.getComment());
        if (config.getDomain() != null) {
            cookie.setDomain(config.getDomain());
        }
        cookie.setHttpOnly(config.isHttpOnly());
        cookie.setPath(config.getPath());
        cookie.setSecure(config.isSecure());
        return cookie;
    }

    protected void updatePreferredLocaleCookie(Locale locale) {
        HttpServletResponse resp = this.currentHttpResponse();
        if (resp != null) {
            this.storePreferredLocaleInCookie(resp, locale);
        }
    }

    protected boolean initUiTheme(HttpServletRequest req, HttpServletResponse resp, Map<String, String> sessionStartupParams) {
        String requestedTheme;
        UiThemeHelper helper = UiThemeHelper.get();
        String modelTheme = this.m_clientSession.getDesktop().getTheme();
        String currentTheme = helper.getTheme(req);
        String validTheme = UiThemeHelper.get().validateTheme(modelTheme);
        if (!ObjectUtility.equals((Object)validTheme, (Object)modelTheme)) {
            LOG.info("Model theme ({}) is not valid, switching to a valid one ({})", (Object)modelTheme, (Object)validTheme);
            modelTheme = validTheme;
        }
        if ((requestedTheme = sessionStartupParams.get(URL_PARAM_THEME)) != null) {
            modelTheme = helper.validateTheme(requestedTheme);
        }
        if (modelTheme == null) {
            modelTheme = (String)ObjectUtility.nvl((Object)currentTheme, (Object)helper.getConfiguredTheme());
            this.m_clientSession.getDesktop().setTheme(currentTheme);
        }
        boolean reloadPage = !modelTheme.equals(currentTheme);
        helper.storeTheme(resp, req.getSession(), modelTheme);
        LOG.debug("UI theme model={} current={} reloadPage={}", new Object[]{modelTheme, currentTheme, reloadPage});
        return reloadPage;
    }

    protected JsonClientSession<?> createClientSessionAdapter(IClientSession clientSession) {
        IFuture future = ModelJobs.schedule(() -> (JsonClientSession)this.createJsonAdapter(clientSession, this.m_rootJsonAdapter), (JobInput)ModelJobs.newInput((ClientRunContext)ClientRunContexts.copyCurrent().withSession(clientSession, true)).withName("Starting JsonClientSession", new Object[0]).withExceptionHandling(null, false));
        return (JsonClientSession)((UiJobs)BEANS.get(UiJobs.class)).awaitAndGet(future);
    }

    protected void startDesktop(Map<String, String> sessionStartupParams) {
        ((UiThreadInterruption)BEANS.get(UiThreadInterruption.class)).detectAndClear(this, "startDesktop");
        IFuture future = ModelJobs.schedule(() -> {
            ((UiThreadInterruption)BEANS.get(UiThreadInterruption.class)).detectAndClear(this, "startDesktop run begin");
            IDesktop desktop = this.m_clientSession.getDesktop();
            IDesktopUIFacade uiFacade = desktop.getUIFacade();
            boolean desktopOpen = desktop.isOpened();
            ((PropertyMap)PropertyMap.CURRENT.get()).put((Object)"handleDeepLink", (Object)(!this.isPersistent() || !desktopOpen ? 1 : 0));
            if (desktopOpen) {
                uiFacade.initStartupRequestParamsFromUI();
            } else {
                uiFacade.openFromUI();
            }
            this.m_attachedToDesktop = true;
            uiFacade.fireGuiAttached();
            ((UiThreadInterruption)BEANS.get(UiThreadInterruption.class)).detectAndClear(this, "startDesktop run end");
        }, (JobInput)ModelJobs.newInput((ClientRunContext)ClientRunContexts.copyCurrent().withSession(this.m_clientSession, true).withProperties(sessionStartupParams)).withName("Starting Desktop", new Object[0]).withExceptionHandling(null, false));
        ((UiJobs)BEANS.get(UiJobs.class)).awaitAndGet(future);
    }

    protected void putReloadPageStartupData() {
        JSONObject startupData = this.m_currentJsonResponse.getStartupData();
        startupData.put(EVENT_RELOAD_PAGE, true);
        startupData.put("clientSessionId", (Object)this.m_clientSession.getId());
    }

    protected void putInitializationStartupData(String clientSessionAdapterId) {
        IFuture future = ModelJobs.schedule(() -> ((IClientSession)this.m_clientSession).getLocale(), (JobInput)ModelJobs.newInput((ClientRunContext)ClientRunContexts.copyCurrent().withSession(this.m_clientSession, true)).withName("Looking up Locale", new Object[0]).withExceptionHandling(null, false));
        JSONObject startupData = this.m_currentJsonResponse.getStartupData();
        startupData.put("clientSessionId", (Object)this.m_clientSession.getId());
        startupData.put("clientSession", (Object)clientSessionAdapterId);
        startupData.put("pollingInterval", CONFIG.getPropertyValue(UiHtmlConfigProperties.BackgroundPollingIntervalProperty.class));
        startupData.put("persistent", this.isPersistent());
        if (Platform.get().inDevelopmentMode()) {
            startupData.put("inDevelopmentMode", true);
        }
        this.putLocaleData(startupData, (Locale)((UiJobs)BEANS.get(UiJobs.class)).awaitAndGet(future));
    }

    protected void putUrlHintsStartupData() {
        JSONObject startupData = this.m_currentJsonResponse.getStartupData();
        if (UrlHints.isInspectorHint((HttpServletRequest)this.currentHttpRequest())) {
            startupData.put("inspector", true);
        }
    }

    @Override
    public final boolean isInitialized() {
        return this.m_initialized;
    }

    @Override
    public boolean isPersistent() {
        return this.m_persistent;
    }

    protected final ISessionStore sessionStore() {
        return this.m_sessionStore;
    }

    @Override
    public String getHttpSessionId() {
        return this.m_sessionStore != null ? this.m_sessionStore.getHttpSessionId() : null;
    }

    @Override
    public final String getUiSessionId() {
        return this.m_uiSessionId;
    }

    protected final void setUiSessionIdInternal(String uiSessionId) {
        this.m_uiSessionId = uiSessionId;
    }

    @Override
    public final String getClientSessionId() {
        return this.m_clientSession == null ? null : this.m_clientSession.getId();
    }

    @Override
    public final IClientSession getClientSession() {
        return this.m_clientSession;
    }

    protected final void setClientSessionInternal(IClientSession clientSession) {
        this.m_clientSession = clientSession;
    }

    @Override
    public void touch() {
        this.m_lastAccessedTime = System.currentTimeMillis();
    }

    @Override
    public long getLastAccessedTime() {
        return this.m_lastAccessedTime;
    }

    @Override
    public void dispose() {
        IClientSession clientSession = this.getClientSession();
        if (this.m_attachedToDesktop && !this.m_disposing && clientSession != null && clientSession.isActive() && !clientSession.isStopping()) {
            Runnable detachGui = () -> {
                if (this.m_attachedToDesktop) {
                    this.m_attachedToDesktop = false;
                    if (clientSession.isActive() && !clientSession.isStopping() && clientSession.getDesktop() != null) {
                        clientSession.getDesktop().getUIFacade().fireGuiDetached();
                    }
                }
            };
            if (ModelJobs.isModelThread()) {
                detachGui.run();
            } else {
                ClientRunContext clientRunContext = ClientRunContexts.copyCurrent((boolean)true).withSession(clientSession, true);
                ModelJobs.schedule(detachGui::run, (JobInput)ModelJobs.newInput((ClientRunContext)clientRunContext).withName("Detaching Gui", new Object[0]).withExceptionHandling(null, false));
            }
        }
        if (this.isProcessingJsonRequest()) {
            this.m_disposing = true;
            return;
        }
        LOG.info("Disposing UI session with ID {}...", (Object)this.getUiSessionId());
        if (this.m_disposed) {
            LOG.trace("UI session with ID {} already disposed.", (Object)this.getUiSessionId());
            return;
        }
        this.m_disposed = true;
        this.sessionStore().unregisterUiSession(this);
        this.uninstallUiDataAvailableListener();
        this.signalPoller();
        this.m_jsonAdapterRegistry.disposeAdapters();
        this.m_httpContext.clear();
        this.m_currentJsonResponse = null;
    }

    @Override
    public final boolean isDisposed() {
        return this.m_disposed;
    }

    protected final void setDisposedInternal(boolean disposed) {
        this.m_disposed = disposed;
    }

    protected final boolean isDisposing() {
        return this.m_disposing;
    }

    protected final void setDisposingInternal(boolean disposing) {
        this.m_disposing = disposing;
    }

    protected final boolean isAttachedToDesktop() {
        return this.m_attachedToDesktop;
    }

    protected final void setAttachedToDesktopInternal(boolean attachedToDesktop) {
        this.m_attachedToDesktop = attachedToDesktop;
    }

    protected Subject currentSubject() {
        return Subject.getSubject(AccessController.getContext());
    }

    @Override
    public JsonResponse currentJsonResponse() {
        return this.m_currentJsonResponse;
    }

    protected final void setCurrentJsonResponseInternal(JsonResponse jsonResponse) {
        this.m_currentJsonResponse = jsonResponse;
    }

    protected final JsonRequest currentJsonRequest() {
        return this.m_currentJsonRequest;
    }

    protected final void setCurrentJsonRequestInternal(JsonRequest jsonRequest) {
        this.m_currentJsonRequest = jsonRequest;
    }

    @Override
    public HttpServletRequest currentHttpRequest() {
        return this.m_httpContext.getRequest();
    }

    @Override
    public HttpServletResponse currentHttpResponse() {
        return this.m_httpContext.getResponse();
    }

    @Override
    public void confirmResponseProcessed(Long sequenceNo) {
        if (sequenceNo == null) {
            return;
        }
        this.m_responseHistory.confirmResponseProcessed(sequenceNo);
    }

    protected void setRequestProcessed(JsonRequest jsonRequest) {
        Long requestSequenceNo = jsonRequest.getSequenceNo();
        if (requestSequenceNo != null) {
            this.m_requestHistory.setRequestProcessed(requestSequenceNo);
        }
    }

    protected boolean isAlreadyProcessed(JsonRequest jsonRequest) {
        Long requestSequenceNo = jsonRequest.getSequenceNo();
        if (requestSequenceNo == null) {
            return false;
        }
        return this.m_requestHistory.isRequestProcessed(requestSequenceNo);
    }

    @Override
    public void verifySubject(HttpServletRequest request) {
        if (this.m_clientSession == null) {
            return;
        }
        Subject subject = ((RunContext)RunContext.CURRENT.get()).getSubject();
        if (subject == null) {
            return;
        }
        if (request.getAttribute("scout.authentication.updatedSubject") != null) {
            this.m_clientSession.setSubject(subject);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public JSONObject processJsonRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse, JsonRequest jsonRequest) {
        if (this.isAlreadyProcessed(jsonRequest)) {
            JSONObject response = this.m_responseHistory.getResponseForRequest(jsonRequest.getSequenceNo());
            LOG.debug("Request #{} was already processed. Sending back response from history.", (Object)jsonRequest.getSequenceNo());
            return response;
        }
        ClientRunContext clientRunContext = ClientRunContexts.copyCurrent().withSession(this.m_clientSession, true);
        this.m_httpContext.set(servletRequest, servletResponse);
        this.m_currentJsonRequest = jsonRequest;
        try {
            this.m_processingJsonRequest = true;
            try {
                ModelJobs.schedule(this::processJsonRequestInternal, (JobInput)this.createJsonRequestModelJobInput(jsonRequest, clientRunContext));
                ((UiJobs)BEANS.get(UiJobs.class)).awaitModelJobs(this.m_clientSession, ExceptionHandler.class);
            }
            finally {
                this.m_processingJsonRequest = false;
            }
            IFuture future = ModelJobs.schedule(this.newResponseToJsonTransformer(), (JobInput)ModelJobs.newInput((ClientRunContext)clientRunContext.copy().withRunMonitor((RunMonitor)BEANS.get(RunMonitor.class))).withName("Transforming response to JSON", new Object[0]).withExecutionHint(UiJobs.EXECUTION_HINT_RESPONSE_TO_JSON).withExecutionHint(UiJobs.EXECUTION_HINT_POLL_REQUEST, jsonRequest.getRequestType() == JsonRequest.RequestType.POLL_REQUEST).withExceptionHandling(null, false));
            try {
                JSONObject jSONObject = (JSONObject)((UiJobs)BEANS.get(UiJobs.class)).awaitAndGet(future);
                return jSONObject;
            }
            catch (ThreadInterruptedError threadInterruptedError) {
                block17: {
                    future.cancel(true);
                    this.setRequestProcessed(jsonRequest);
                    this.m_httpContext.clear();
                    this.m_currentJsonRequest = null;
                    if (!this.m_disposing) break block17;
                    this.dispose();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adapter count after request: {}", (Object)this.m_jsonAdapterRegistry.size());
                }
                return null;
            }
            catch (FutureCancelledError futureCancelledError) {
                block18: {
                    this.setRequestProcessed(jsonRequest);
                    this.m_httpContext.clear();
                    this.m_currentJsonRequest = null;
                    if (!this.m_disposing) break block18;
                    this.dispose();
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adapter count after request: {}", (Object)this.m_jsonAdapterRegistry.size());
                }
                return null;
            }
        }
        finally {
            this.setRequestProcessed(jsonRequest);
            this.m_httpContext.clear();
            this.m_currentJsonRequest = null;
            if (this.m_disposing) {
                this.dispose();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adapter count after request: {}", (Object)this.m_jsonAdapterRegistry.size());
            }
        }
    }

    protected JobInput createJsonRequestModelJobInput(JsonRequest jsonRequest, ClientRunContext clientRunContext) {
        return ModelJobs.newInput((ClientRunContext)clientRunContext).withName("Processing JSON request", new Object[0]).withExecutionHint(UiJobs.EXECUTION_HINT_POLL_REQUEST, jsonRequest.getRequestType() == JsonRequest.RequestType.POLL_REQUEST).withExceptionHandling((ExceptionHandler)BEANS.get(ExceptionHandler.class), true);
    }

    protected final boolean isProcessingJsonRequest() {
        return this.m_processingJsonRequest;
    }

    protected final void setProcessingJsonRequest(boolean processingJsonRequest) {
        this.m_processingJsonRequest = processingJsonRequest;
    }

    protected void processJsonRequestInternal() {
        this.m_jsonEventProcessor.processEvents(this.m_currentJsonRequest, this.m_currentJsonResponse);
    }

    protected JSONObject responseToJsonInternal() {
        JSONObject json = this.m_currentJsonResponse.toJson();
        if (this.m_currentJsonResponse.getSequenceNo() != null) {
            Long currentRequestSequenceNo = this.m_currentJsonRequest == null ? null : this.m_currentJsonRequest.getSequenceNo();
            this.m_responseHistory.registerResponse(this.m_currentJsonResponse.getSequenceNo(), json, currentRequestSequenceNo);
        }
        return json;
    }

    protected Callable<JSONObject> newResponseToJsonTransformer() {
        return () -> {
            try {
                JSONObject jSONObject = this.responseToJsonInternal();
                return jSONObject;
            }
            catch (RuntimeException e) {
                LOG.warn("Error while transforming response to JSON: {}", (Object)this.m_currentJsonResponse, (Object)e);
                JSONObject jSONObject = UiSession.getJsonRequestHelper().createUnrecoverableFailureResponse(this.m_currentJsonResponse.getSequenceNo());
                return jSONObject;
            }
            finally {
                this.m_currentJsonResponse = this.createJsonResponse();
            }
        };
    }

    @Override
    public JSONObject processFileUpload(HttpServletRequest req, HttpServletResponse res, IUploadable uploadable, List<BinaryResource> uploadResources, Map<String, String> uploadProperties) {
        if (uploadable instanceof IBinaryResourceConsumer) {
            return this.processFileUploadWithConsumer(req, res, (IBinaryResourceConsumer)uploadable, uploadResources, uploadProperties);
        }
        if (uploadable instanceof IBinaryResourceUploader) {
            return this.processFileUploadWithUploader(req, res, (IBinaryResourceUploader)uploadable, uploadResources, uploadProperties);
        }
        throw new IllegalStateException("resourceHandler must be either a IBinaryResourceConsumer or a IBinaryResourceUploader");
    }

    /*
     * Loose catch block
     */
    protected JSONObject processFileUploadWithConsumer(HttpServletRequest req, HttpServletResponse res, IBinaryResourceConsumer resourceConsumer, List<BinaryResource> uploadResources, Map<String, String> uploadProperties) {
        ClientRunContext clientRunContext = ClientRunContexts.copyCurrent().withSession(this.m_clientSession, true);
        this.m_httpContext.set(req, res);
        try {
            this.m_processingJsonRequest = true;
            try {
                ModelJobs.schedule(() -> {
                    if (uploadResources != null) {
                        resourceConsumer.consumeBinaryResource(uploadResources, uploadProperties);
                    } else {
                        this.markFileUploadFailed(resourceConsumer);
                    }
                }, (JobInput)this.createFileUploadModelJobInput(clientRunContext));
                ((UiJobs)BEANS.get(UiJobs.class)).awaitModelJobs(this.m_clientSession, ExceptionHandler.class);
            }
            finally {
                this.m_processingJsonRequest = false;
            }
            IFuture future = ModelJobs.schedule(this.newResponseToJsonTransformer(), (JobInput)ModelJobs.newInput((ClientRunContext)clientRunContext.copy().withRunMonitor((RunMonitor)BEANS.get(RunMonitor.class))).withName("Transforming response to JSON", new Object[0]).withExecutionHint(UiJobs.EXECUTION_HINT_RESPONSE_TO_JSON).withExceptionHandling(null, false));
            try {
                JSONObject jSONObject = (JSONObject)((UiJobs)BEANS.get(UiJobs.class)).awaitAndGet(future);
                return jSONObject;
            }
            catch (ThreadInterruptedError threadInterruptedError) {
                future.cancel(true);
                this.m_httpContext.clear();
                if (this.m_disposing) {
                    this.dispose();
                }
                return null;
            }
            catch (FutureCancelledError futureCancelledError) {
                this.m_httpContext.clear();
                if (this.m_disposing) {
                    this.dispose();
                }
                return null;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.m_httpContext.clear();
            if (this.m_disposing) {
                this.dispose();
            }
        }
    }

    protected void markFileUploadFailed(IBinaryResourceConsumer resourceConsumer) {
        Object model;
        if (resourceConsumer instanceof JsonFormField && (model = ((JsonFormField)((Object)resourceConsumer)).getModel()) instanceof IFormField) {
            ((IFormField)model).addErrorStatus((IStatus)new ValidationFailedStatus(TEXTS.get((String)"ui.RejectedUpload")));
            return;
        }
        this.m_currentJsonResponse.markAsError(31, "Rejected file upload.");
    }

    protected JSONObject processFileUploadWithUploader(HttpServletRequest req, HttpServletResponse res, IBinaryResourceUploader resourceUploader, List<BinaryResource> uploadResources, Map<String, String> uploadProperties) {
        ClientRunContext clientRunContext = ClientRunContexts.copyCurrent().withSession(this.m_clientSession, true);
        IFuture future = ModelJobs.schedule(() -> {
            if (uploadResources != null) {
                return resourceUploader.uploadBinaryResources(uploadResources, uploadProperties);
            }
            this.markFileUploadFailed(resourceUploader);
            return Collections.emptyList();
        }, (JobInput)this.createFileUploadModelJobInput(clientRunContext));
        List links = (List)future.awaitDoneAndGet();
        if (uploadResources.size() != links.size()) {
            throw new IllegalStateException("Must return a link for each uploaded resource");
        }
        JSONObject json = new JSONObject();
        if (links.size() == 1) {
            json.put("link", links.get(0));
        } else {
            JSONArray array = new JSONArray();
            links.forEach(arg_0 -> ((JSONArray)array).put(arg_0));
            json.put("links", (Object)array);
        }
        LOG.debug("Uploaded " + links.size() + " resources. Returning links to resoruce=" + json);
        return json;
    }

    protected void markFileUploadFailed(IBinaryResourceUploader resourceUploader) {
        this.m_currentJsonResponse.markAsError(31, "Rejected file upload.");
    }

    protected JobInput createFileUploadModelJobInput(ClientRunContext clientRunContext) {
        return ModelJobs.newInput((ClientRunContext)clientRunContext).withName("Processing file upload request", new Object[0]).withExceptionHandling((ExceptionHandler)BEANS.get(ExceptionHandler.class), true);
    }

    @Override
    public void processCancelRequest() {
        ((UiJobs)BEANS.get(UiJobs.class)).cancelModelJobs(this.getClientSession());
    }

    @Override
    public JSONObject processSyncResponseQueueRequest(JsonRequest jsonRequest) {
        return this.m_responseHistory.toSyncResponse();
    }

    @Override
    public void logout() {
        LOG.info("Logging out from UI session with ID {} [clientSessionId={}, processingJsonRequest={}]", new Object[]{this.getUiSessionId(), this.getClientSessionId(), this.isProcessingJsonRequest()});
        ((UiThreadInterruption)BEANS.get(UiThreadInterruption.class)).detectAndClear(this, "logout");
        if (this.isProcessingJsonRequest()) {
            boolean platformValid;
            boolean bl = platformValid = Platform.get() != null && Platform.get().getState() == IPlatform.State.PlatformStarted;
            if (this.m_currentJsonResponse != null && platformValid) {
                this.m_currentJsonResponse.addActionEvent(this.getUiSessionId(), "logout", this.createLogoutEventData());
            }
        }
        this.dispose();
        LOG.info("Logged out successfully from UI session with ID {}", (Object)this.getUiSessionId());
    }

    protected JSONObject createLogoutEventData() {
        JSONObject obj = new JSONObject();
        obj.put("redirectUrl", (Object)this.getLogoutRedirectUrl());
        return obj;
    }

    @Override
    public String getLogoutRedirectUrl() {
        return "logout";
    }

    @Override
    public final IJsonAdapter<?> getRootJsonAdapter() {
        return this.m_rootJsonAdapter;
    }

    @Override
    public String createUniqueId() {
        return "" + this.m_jsonAdapterSeq.incrementAndGet();
    }

    @Override
    public IJsonAdapter<?> getJsonAdapter(String id) {
        return this.m_jsonAdapterRegistry.getById(id);
    }

    @Override
    public <M> List<IJsonAdapter<M>> getJsonAdapters(M model) {
        return this.m_jsonAdapterRegistry.getByModel(model);
    }

    @Override
    public List<IJsonAdapter<?>> getJsonChildAdapters(IJsonAdapter<?> parent) {
        return this.m_jsonAdapterRegistry.getByParentAdapter(parent);
    }

    @Override
    public <M, A extends IJsonAdapter<M>> A getJsonAdapter(M model, IJsonAdapter<?> parent) {
        return this.getJsonAdapter(model, parent, true);
    }

    @Override
    public <M, A extends IJsonAdapter<M>> A getJsonAdapter(M model, IJsonAdapter<?> parent, boolean checkRoot) {
        Object jsonAdapter = this.m_jsonAdapterRegistry.getByModelAndParentAdapter(model, parent);
        if (jsonAdapter == null && checkRoot) {
            jsonAdapter = this.m_jsonAdapterRegistry.getByModelAndParentAdapter(model, this.getRootJsonAdapter());
        }
        return (A)jsonAdapter;
    }

    @Override
    public <M, A extends IJsonAdapter<M>> A getOrCreateJsonAdapter(M model, IJsonAdapter<?> parent) {
        A jsonAdapter = this.getJsonAdapter(model, parent);
        if (jsonAdapter != null) {
            return jsonAdapter;
        }
        return this.createJsonAdapter(model, parent);
    }

    @Override
    public <M, A extends IJsonAdapter<M>> A createJsonAdapter(M model, IJsonAdapter<?> parent) {
        A jsonAdapter = this.newJsonAdapter(model, parent);
        this.m_listeners.fireEvent(new UiSessionEvent(this, 100, (IJsonAdapter<?>)jsonAdapter));
        this.m_currentJsonResponse.addAdapter((IJsonAdapter<?>)jsonAdapter);
        return jsonAdapter;
    }

    protected <M, A extends IJsonAdapter<M>> A newJsonAdapter(M model, IJsonAdapter<?> parent) {
        String id = this.createUniqueId();
        IJsonAdapter<?> adapter = MainJsonObjectFactory.get().createJsonAdapter(model, this, id, parent);
        adapter.init();
        return (A)adapter;
    }

    @Override
    public void registerJsonAdapter(IJsonAdapter<?> jsonAdapter) {
        this.m_jsonAdapterRegistry.add(jsonAdapter);
    }

    @Override
    public void unregisterJsonAdapter(IJsonAdapter<?> jsonAdapter) {
        this.m_jsonAdapterRegistry.remove(jsonAdapter.getId());
        this.m_currentJsonResponse.removeJsonAdapter(jsonAdapter.getId());
        this.m_listeners.fireEvent(new UiSessionEvent(this, 200, jsonAdapter));
    }

    protected void installUiDataAvailableListener(IClientSession clientSession) {
        this.uninstallUiDataAvailableListener();
        this.m_uiDataAvailableListener = Jobs.getJobManager().addListener(ModelJobs.newEventFilterBuilder().andMatch((Predicate)new SessionJobEventFilter((ISession)clientSession)).andMatchNotExecutionHint(UiJobs.EXECUTION_HINT_POLL_REQUEST).andMatchNotExecutionHint(UiJobs.EXECUTION_HINT_RESPONSE_TO_JSON).andMatch(this.newUiDataAvailableFilter()).andMatch(event -> !this.isProcessingJsonRequest()).toFilter(), event -> {
            LOG.trace("Model job finished. Wake up 'poll-request'. [job={}, eventType={}]", (Object)event.getData().getFuture().getJobInput().getName(), (Object)event.getType());
            this.signalPoller();
        });
    }

    protected Predicate<JobEvent> newUiDataAvailableFilter() {
        return new Predicate<JobEvent>(){

            @Override
            public boolean test(JobEvent event) {
                switch (event.getType()) {
                    case JOB_STATE_CHANGED: {
                        return this.isJobDone(event.getData().getState(), event.getData().getFuture());
                    }
                    case JOB_EXECUTION_HINT_ADDED: {
                        return "ui.interaction.required".equals(event.getData().getExecutionHint());
                    }
                }
                return false;
            }

            private boolean isJobDone(JobState jobState, IFuture<?> future) {
                if (jobState == JobState.DONE) {
                    return true;
                }
                return jobState == JobState.PENDING && !future.isSingleExecution();
            }
        };
    }

    protected void uninstallUiDataAvailableListener() {
        if (this.m_uiDataAvailableListener != null) {
            this.m_uiDataAvailableListener.dispose();
            this.m_uiDataAvailableListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForBackgroundJobs(JsonRequest jsonRequest, int pollWaitSeconds) throws InterruptedException {
        Object object = this.m_pollerQueueLock;
        synchronized (object) {
            if (this.m_pollerMonitor != null) {
                this.m_pollerMonitor.cancel(true);
            }
            this.m_pollerMonitor = (RunMonitor)RunMonitor.CURRENT.get();
        }
        if (this.isAlreadyProcessed(jsonRequest)) {
            object = this.m_pollerQueueLock;
            synchronized (object) {
                this.m_pollerMonitor = null;
            }
            return;
        }
        LOG.trace("Wait for max. {} seconds until background job terminates or wait timeout occurs...", (Object)pollWaitSeconds);
        long maxPollWait = pollWaitSeconds * 1000;
        long t0 = System.currentTimeMillis();
        long pollWait = maxPollWait;
        boolean wait = true;
        while (wait) {
            Object notificationToken = this.m_pollerQueue.poll(pollWait, TimeUnit.MILLISECONDS);
            long elapsed = System.currentTimeMillis() - t0;
            pollWait = maxPollWait - elapsed;
            if (notificationToken == null || pollWait < 100L || this.m_disposed || !this.m_currentJsonResponse.isEmpty()) {
                wait = false;
                continue;
            }
            LOG.trace("Background job terminated, but there is nothing to respond. Going back to sleep for max. {} ms.", (Object)pollWait);
        }
        if (!this.m_disposed) {
            Thread.sleep(100L);
        }
        Object object2 = this.m_pollerQueueLock;
        synchronized (object2) {
            this.m_pollerMonitor = null;
        }
        LOG.trace("Background job terminated. Continue request processing...");
    }

    protected void signalPoller() {
        this.m_pollerQueue.offer(this.m_notificationToken);
    }

    @Override
    public void sendLocaleChangedEvent(Locale locale) {
        JSONObject jsonEvent = new JSONObject();
        this.putLocaleData(jsonEvent, locale);
        this.m_currentJsonResponse.addActionEvent(this.getUiSessionId(), EVENT_LOCALE_CHANGED, jsonEvent);
        this.updatePreferredLocaleCookie(locale);
    }

    protected void putLocaleData(JSONObject json, Locale locale) {
        json.put("locale", (Object)JsonLocale.toJson(locale));
        json.put("textMap", (Object)this.getTextMap(locale));
    }

    protected JSONObject getTextMap(Locale locale) {
        TreeSet<String> textKeys = new TreeSet<String>();
        for (IUiTextContributor contributor : BEANS.all(IUiTextContributor.class)) {
            contributor.contributeUiTextKeys(textKeys);
            LOG.debug("Gathered UI text keys from contributor {}", (Object)contributor);
        }
        JSONObject map = new JSONObject();
        for (String textKey : textKeys) {
            String text = TEXTS.getWithFallback((Locale)locale, (String)textKey, null, (String[])new String[0]);
            if (text != null) {
                map.put(textKey, (Object)text);
                continue;
            }
            LOG.warn("Could not find text for contributed UI text key '{}'", (Object)textKey);
        }
        return map;
    }

    @Override
    public void sendDisposeAdapterEvent(IJsonAdapter<?> adapter) {
        JSONObject jsonEvent = new JSONObject();
        jsonEvent.put("adapter", (Object)adapter.getId());
        this.m_currentJsonResponse.addActionEvent(this.getUiSessionId(), EVENT_DISPOSE_ADAPTER, jsonEvent);
    }

    @Override
    public void updateTheme(String theme) {
        UiThemeHelper.get().storeTheme(this.currentHttpResponse(), this.sessionStore().getHttpSession(), theme);
        this.sendReloadPageEvent();
        LOG.info("UI theme changed to: {}", (Object)theme);
    }

    @Override
    public void sendReloadPageEvent() {
        this.m_currentJsonResponse.addActionEvent(this.getUiSessionId(), EVENT_RELOAD_PAGE);
    }

    @Override
    public IHttpResourceCache getHttpResourceCache() {
        return this.m_httpResourceCache;
    }

    @Override
    public UiSessionListeners listeners() {
        return this.m_listeners;
    }

    protected static HttpSessionHelper getHttpSessionHelper() {
        return (HttpSessionHelper)HTTP_SESSION_HELPER.get();
    }

    protected static JsonRequestHelper getJsonRequestHelper() {
        return (JsonRequestHelper)JSON_REQUEST_HELPER.get();
    }

    public static IUiSession get(HttpServletRequest req, JSONObject jsonObject) {
        if (req == null || jsonObject == null) {
            return null;
        }
        return UiSession.get(req, new JsonRequest(jsonObject));
    }

    public static IUiSession get(HttpServletRequest req, JsonRequest jsonReq) {
        if (req == null || jsonReq == null) {
            return null;
        }
        return UiSession.get(req, jsonReq.getUiSessionId());
    }

    public static IUiSession get(HttpServletRequest req, String uiSessionId) {
        if (req == null || uiSessionId == null) {
            return null;
        }
        HttpSession httpSession = req.getSession(false);
        if (httpSession == null) {
            return null;
        }
        ISessionStore sessionStore = UiSession.getHttpSessionHelper().getSessionStore(httpSession);
        return sessionStore.getUiSession(uiSessionId);
    }

    public static class HttpContext {
        private HttpServletRequest m_req;
        private HttpServletResponse m_resp;

        public synchronized void clear() {
            this.m_req = null;
            this.m_resp = null;
        }

        public synchronized void set(HttpServletRequest req, HttpServletResponse resp) {
            this.m_req = req;
            this.m_resp = resp;
        }

        public synchronized HttpServletRequest getRequest() {
            return this.m_req;
        }

        public synchronized HttpServletResponse getResponse() {
            return this.m_resp;
        }
    }

    private static class P_RootAdapter
    extends AbstractJsonAdapter<Object> {
        public P_RootAdapter(IUiSession uiSession) {
            super(new Object(), uiSession, "1", null);
        }

        @Override
        public String getObjectType() {
            return "GlobalAdapter";
        }
    }
}

