/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.clipboard;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.scout.rt.client.services.common.clipboard.IClipboardService;
import org.eclipse.scout.rt.client.ui.dnd.TextTransferObject;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.form.clipboard.ClipboardForm;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.resource.BinaryResources;
import org.eclipse.scout.rt.platform.resource.MimeType;
import org.eclipse.scout.rt.platform.util.StringUtility;

public class HtmlScoutClipboardService
implements IClipboardService {
    public Collection<BinaryResource> getClipboardContents(MimeType ... mimeTypes) {
        ClipboardForm form = new ClipboardForm();
        form.setMimeTypes(mimeTypes);
        this.execInitClipboardForm(form);
        form.startPaste();
        form.waitFor();
        if (form.isFormStored()) {
            return (Collection)form.getClipboardField().getValue();
        }
        return Collections.emptyList();
    }

    protected void execInitClipboardForm(ClipboardForm form) {
    }

    public void setContents(TransferObject transferObject) {
        if (transferObject instanceof TextTransferObject) {
            this.setTextContents(((TextTransferObject)transferObject).getPlainText());
            return;
        }
        throw new ProcessingException("Not implemented", new Object[0]);
    }

    public void setTextContents(String textContents) {
        ClipboardForm form = new ClipboardForm();
        form.setMimeTypes(new MimeType[]{MimeType.TXT});
        BinaryResource binaryResource = BinaryResources.create().withContentType(MimeType.TXT.getType()).withContent(StringUtility.emptyIfNull((Object)textContents)).build();
        form.getClipboardField().setValue(Collections.singleton(binaryResource));
        this.execInitClipboardForm(form);
        form.startCopy();
    }
}

