/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.csp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.ui.html.AbstractUiServletRequestHandler;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=5400.0)
public class ContentSecurityPolicyReportHandler
extends AbstractUiServletRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ContentSecurityPolicyReportHandler.class);
    private static final String HANDLER_PATH = "/csp-report";
    private static final int MAX_CSP_REPORT_DATALENGTH = 4096;

    @Override
    public boolean handlePost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!ObjectUtility.equals((Object)req.getPathInfo(), (Object)HANDLER_PATH)) {
            return false;
        }
        this.log(this.getReport(req));
        return true;
    }

    protected String getReport(HttpServletRequest req) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader in = req.getReader();){
            String cspReportData = IOUtility.readString((Reader)in, (int)4096);
            if (((Reader)in).read() != -1) {
                cspReportData = String.valueOf(cspReportData) + "... [only first 4096 bytes shown]";
            } else {
                try {
                    JSONObject json = new JSONObject(cspReportData);
                    cspReportData = json.toString(2);
                }
                catch (RuntimeException e) {
                    LOG.trace("Error while converting CSP report to JSON", (Throwable)e);
                }
            }
            return cspReportData;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void log(String report) {
        LOG.info("CSP-REPORT: {}", (Object)report);
    }
}

