/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.resource.BinaryResources;
import org.eclipse.scout.rt.platform.util.FileUtility;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.ui.html.json.DefaultValuesFilter;
import org.eclipse.scout.rt.ui.html.json.IDefaultValuesConfigurationContributor;
import org.eclipse.scout.rt.ui.html.json.IDefaultValuesFilterService;
import org.eclipse.scout.rt.ui.html.json.JsonObjectUtility;
import org.eclipse.scout.rt.ui.html.json.JsonUtility;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValuesFilterService
implements IDefaultValuesFilterService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultValuesFilterService.class);
    private static final long FILE_UPDATE_CHECK_INTERVAL = 1234L;
    private DefaultValuesFilter m_filter;
    private volatile long m_lastModified = -1L;
    private long m_lastCheckForFileUpdate = -1L;
    private String m_combinedDefaultValuesConfiguration = null;

    protected DefaultValuesFilter getFilter() {
        return this.m_filter;
    }

    protected void setFilter(DefaultValuesFilter filter) {
        this.m_filter = filter;
    }

    @Override
    public void filter(JSONObject json) {
        try {
            this.ensureLoaded();
            this.m_filter.filter(json);
        }
        catch (RuntimeException e) {
            LOG.error("Error while filtering default values", (Throwable)e);
        }
    }

    @Override
    public void filter(JSONObject json, String objectType) {
        try {
            this.ensureLoaded();
            this.m_filter.filter(json, objectType);
        }
        catch (RuntimeException e) {
            LOG.error("Error while filtering default values", (Throwable)e);
        }
    }

    protected List<URL> getDefaultValuesConfigurationUrls() {
        ArrayList<URL> urls = new ArrayList<URL>();
        List contributors = BEANS.all(IDefaultValuesConfigurationContributor.class);
        Collections.reverse(contributors);
        for (IDefaultValuesConfigurationContributor contributor : contributors) {
            URL url = contributor.contributeDefaultValuesConfigurationUrl();
            if (url == null) continue;
            urls.add(url);
        }
        return urls;
    }

    protected void ensureLoaded() {
        long time;
        DefaultValuesFilter filter = this.m_filter;
        if (filter != null && Platform.get().inDevelopmentMode() && (time = System.currentTimeMillis()) - this.m_lastCheckForFileUpdate > 1234L) {
            this.m_lastCheckForFileUpdate = time;
            List<URL> urls = this.getDefaultValuesConfigurationUrls();
            for (URL url : urls) {
                try {
                    URLConnection conn = url.openConnection();
                    long lastModified = conn.getLastModified();
                    if (lastModified <= this.m_lastModified) continue;
                    LOG.info("Detected modification in {}", (Object)url);
                    this.loadFilter();
                    break;
                }
                catch (Exception e) {
                    LOG.warn("Error while checking for file modification of {}", (Object)url, (Object)e);
                }
            }
        }
        if (this.m_filter == null) {
            this.loadFilter();
        }
    }

    protected synchronized void loadFilter() {
        try {
            List<URL> urls = this.getDefaultValuesConfigurationUrls();
            long newestModified = 0L;
            ArrayList<JSONObject> defaultValuesConfigurations = new ArrayList<JSONObject>();
            for (URL url : urls) {
                String jsonData;
                URLConnection conn = url.openConnection();
                long lastModified = conn.getLastModified();
                if (lastModified > newestModified) {
                    newestModified = lastModified;
                }
                Throwable throwable = null;
                Object var12_12 = null;
                try (InputStream in = conn.getInputStream();){
                    jsonData = IOUtility.readStringUTF8((InputStream)in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                jsonData = JsonUtility.stripCommentsFromJson(jsonData);
                JSONObject json = new JSONObject(jsonData);
                defaultValuesConfigurations.add(json);
            }
            this.m_lastModified = newestModified;
            JSONObject combinedDefaultValuesConfiguration = new JSONObject();
            for (JSONObject defaultValuesConfiguration : defaultValuesConfigurations) {
                JsonObjectUtility.mergeProperties(combinedDefaultValuesConfiguration, defaultValuesConfiguration);
            }
            this.m_combinedDefaultValuesConfiguration = JsonObjectUtility.toString(combinedDefaultValuesConfiguration);
            DefaultValuesFilter filter = (DefaultValuesFilter)BEANS.get(DefaultValuesFilter.class);
            filter.importConfiguration(combinedDefaultValuesConfiguration);
            this.m_filter = filter;
        }
        catch (Exception e) {
            throw new ProcessingException("Unexpected error while initializing default values filter", new Object[]{e});
        }
    }

    @Override
    public synchronized String getCombinedDefaultValuesConfiguration() {
        this.ensureLoaded();
        return this.m_combinedDefaultValuesConfiguration;
    }

    @Override
    public synchronized BinaryResource getCombinedDefaultValuesConfigurationFile(String targetFilename) {
        this.ensureLoaded();
        byte[] content = this.m_combinedDefaultValuesConfiguration == null ? null : this.m_combinedDefaultValuesConfiguration.getBytes(StandardCharsets.UTF_8);
        return BinaryResources.create().withFilename(targetFilename).withContentType(FileUtility.getContentTypeForExtension((String)"json")).withContent(content).withLastModified(this.m_lastModified).withCachingAllowed(true).withCacheMaxAge(14400).build();
    }
}

