/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;

public class JsonAdapterReferenceTracker {
    private final Map<Object, Set<Object>> m_usageMap = new HashMap<Object, Set<Object>>();
    private final Set<IJsonAdapter<?>> m_unreferencedAdapters = new HashSet();

    public void put(IJsonAdapter<?> jsonAdapter, IJsonAdapter<?> parent) {
        HashSet parents = new HashSet();
        if (parent != null) {
            parents.add(parent);
        }
        this.m_usageMap.put(jsonAdapter, parents);
        this.m_unreferencedAdapters.remove(jsonAdapter);
    }

    public void remove(IJsonAdapter<?> jsonAdapter, IJsonAdapter<?> parent) {
        Set<Object> parents = this.m_usageMap.get(jsonAdapter);
        if (parents != null) {
            if (parent == null) {
                parents.clear();
            } else {
                parents.remove(parent);
            }
        }
        if (parents == null || parents.isEmpty()) {
            this.m_unreferencedAdapters.add(jsonAdapter);
        }
    }

    public Set<IJsonAdapter<?>> unreferencedAdapters() {
        return this.m_unreferencedAdapters;
    }
}

