/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.util.Collection;
import java.util.function.Predicate;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.form.fields.ModelVariant;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.json.JSONArray;

public final class JsonAdapterUtility {
    private JsonAdapterUtility() {
    }

    public static <M> String getAdapterIdForModel(IUiSession uiSession, M model, IJsonAdapter<?> parent) {
        return JsonAdapterUtility.getAdapterIdForModel(uiSession, model, parent, null);
    }

    public static <M> String getAdapterIdForModel(IUiSession uiSession, M model, IJsonAdapter<?> parent, Predicate<M> filter) {
        if (filter != null && !filter.test(model)) {
            return null;
        }
        Object adapter = uiSession.getJsonAdapter(model, parent);
        if (adapter == null) {
            throw new IllegalArgumentException("No adapter registered for model=" + model);
        }
        return adapter.getId();
    }

    public static <M> JSONArray getAdapterIdsForModel(IUiSession uiSession, Collection<M> models, IJsonAdapter<?> parent, Predicate<M> filter) {
        JSONArray jsonAdapterIds = new JSONArray();
        for (M model : models) {
            String adapterId = JsonAdapterUtility.getAdapterIdForModel(uiSession, model, parent, filter);
            if (adapterId == null) continue;
            jsonAdapterIds.put((Object)adapterId);
        }
        return jsonAdapterIds;
    }

    public static <M> JSONArray getAdapterIdsForModel(IUiSession uiSession, Collection<M> models, IJsonAdapter<?> parent) {
        return JsonAdapterUtility.getAdapterIdsForModel(uiSession, models, parent, null);
    }

    public static String getObjectType(String objectType, Object model) {
        ModelVariant modelVariant;
        if (model.getClass().isAnnotationPresent(ModelVariant.class) && StringUtility.hasText((CharSequence)(modelVariant = model.getClass().getAnnotation(ModelVariant.class)).value())) {
            return String.valueOf(objectType) + ":" + modelVariant.value();
        }
        return objectType;
    }

    public static IJsonAdapter<?> findChildAdapter(IJsonAdapter<?> parentJsonAdapter, IWidget widget) {
        if (parentJsonAdapter != null) {
            for (IJsonAdapter<IWidget> potential : parentJsonAdapter.getUiSession().getJsonAdapters(widget)) {
                if (!potential.hasAncestor(parentJsonAdapter)) continue;
                return potential;
            }
        }
        return null;
    }

    public static <T> JSONArray adapterIdsToJson(Collection<IJsonAdapter<T>> adapters) {
        return JsonAdapterUtility.adapterIdsToJson(adapters, null);
    }

    public static <T> JSONArray adapterIdsToJson(Collection<IJsonAdapter<T>> adapters, Predicate<T> filter) {
        if (adapters == null) {
            return null;
        }
        JSONArray array = new JSONArray();
        for (IJsonAdapter<T> adapter : adapters) {
            if (filter != null && !filter.test(adapter.getModel())) continue;
            array.put((Object)adapter.getId());
        }
        return array;
    }
}

