/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.scout.rt.platform.annotations.IgnoreProperty;
import org.eclipse.scout.rt.platform.reflect.FastBeanInfo;
import org.eclipse.scout.rt.platform.reflect.FastPropertyDescriptor;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.IJsonObjectFactory;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceMediator;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonBean
implements IJsonObject {
    private final Object m_bean;
    private final IJsonObjectFactory m_objectFactory;
    private BinaryResourceMediator m_binaryResourceMediator;

    public JsonBean(Object bean, IJsonObjectFactory objectFactory) {
        this.m_bean = bean;
        this.m_objectFactory = objectFactory;
    }

    public void setBinaryResourceMediator(BinaryResourceMediator binaryResourceMediator) {
        this.m_binaryResourceMediator = binaryResourceMediator;
    }

    @Override
    public Object toJson() {
        if (this.m_bean == null) {
            return null;
        }
        Class<?> type = this.m_bean.getClass();
        if (type.isPrimitive() || type == String.class || type == Boolean.class || Number.class.isAssignableFrom(type)) {
            return this.m_bean;
        }
        if (BinaryResource.class.isAssignableFrom(type)) {
            BinaryResource binaryResource = (BinaryResource)this.m_bean;
            this.m_binaryResourceMediator.addBinaryResource(binaryResource);
            return this.m_binaryResourceMediator.createUrl(binaryResource);
        }
        if (type.isArray()) {
            JSONArray jsonArray = new JSONArray();
            int n = Array.getLength(this.m_bean);
            int i = 0;
            while (i < n) {
                IJsonObject jsonObject = this.createJsonObject(Array.get(this.m_bean, i));
                jsonArray.put(jsonObject.toJson());
                ++i;
            }
            return jsonArray;
        }
        if (Collection.class.isAssignableFrom(type)) {
            JSONArray jsonArray = new JSONArray();
            Collection collection = (Collection)this.m_bean;
            for (Object object : collection) {
                IJsonObject jsonObject = this.createJsonObject(object);
                jsonArray.put(jsonObject.toJson());
            }
            return jsonArray;
        }
        if (Map.class.isAssignableFrom(type)) {
            JSONObject jsonMap = new JSONObject();
            Map map = (Map)this.m_bean;
            Set entries = map.entrySet();
            for (Map.Entry entry : entries) {
                if (!(entry.getKey() instanceof String)) {
                    throw new IllegalArgumentException("Cannot convert " + type + " to json object");
                }
                IJsonObject jsonObject = this.createJsonObject(entry.getValue());
                jsonMap.put((String)entry.getKey(), jsonObject.toJson());
            }
            return jsonMap;
        }
        if (type.getName().startsWith("java.")) {
            throw new IllegalArgumentException("Cannot convert " + type + " to json object");
        }
        try {
            TreeMap<String, Object> properties = new TreeMap<String, Object>();
            Field[] fieldArray = type.getFields();
            int entry = fieldArray.length;
            int entries = 0;
            while (entries < entry) {
                Field f = fieldArray[entries];
                if (!Modifier.isStatic(f.getModifiers())) {
                    String key = f.getName();
                    Object val = f.get(this.m_bean);
                    IJsonObject jsonObject = this.createJsonObject(val);
                    properties.put(key, jsonObject.toJson());
                }
                ++entries;
            }
            FastBeanInfo beanInfo = new FastBeanInfo(type, Object.class);
            FastPropertyDescriptor[] fastPropertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = fastPropertyDescriptorArray.length;
            entry = 0;
            while (entry < n) {
                IgnoreProperty ignoredPropertyAnnotation;
                FastPropertyDescriptor desc = fastPropertyDescriptorArray[entry];
                Method m = desc.getReadMethod();
                if (!(m == null || (ignoredPropertyAnnotation = m.getAnnotation(IgnoreProperty.class)) != null && IgnoreProperty.Context.GUI.equals((Object)ignoredPropertyAnnotation.value()))) {
                    String key = desc.getName();
                    Object val = m.invoke(this.m_bean, new Object[0]);
                    IJsonObject jsonObject = this.createJsonObject(val);
                    properties.put(key, jsonObject.toJson());
                }
                ++entry;
            }
            JSONObject jbean = new JSONObject();
            for (Map.Entry e : properties.entrySet()) {
                jbean.put((String)e.getKey(), e.getValue());
            }
            return jbean;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(type + " to json", e);
        }
    }

    protected IJsonObject createJsonObject(Object object) {
        IJsonObject jsonObject = this.m_objectFactory.createJsonObject(object);
        if (jsonObject instanceof JsonBean) {
            ((JsonBean)jsonObject).setBinaryResourceMediator(this.m_binaryResourceMediator);
        }
        return jsonObject;
    }
}

