/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.util.Locale;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.shared.session.ISessionListener;
import org.eclipse.scout.rt.shared.session.SessionEvent;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonPropertyObserver;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.json.JSONObject;

public class JsonClientSession<CLIENT_SESSION extends IClientSession>
extends AbstractJsonPropertyObserver<CLIENT_SESSION> {
    private ISessionListener m_sessionListener;

    public JsonClientSession(CLIENT_SESSION model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return null;
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        if (this.m_sessionListener != null) {
            throw new IllegalStateException();
        }
        this.m_sessionListener = new P_SessionListener();
        ((IClientSession)this.getModel()).addListener(this.m_sessionListener);
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        if (this.m_sessionListener == null) {
            throw new IllegalStateException();
        }
        ((IClientSession)this.getModel()).removeListener(this.m_sessionListener);
        this.m_sessionListener = null;
    }

    @Override
    protected void attachChildAdapters() {
        super.attachChildAdapters();
        this.attachAdapter(((IClientSession)this.getModel()).getDesktop());
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        this.putAdapterIdProperty(json, "desktop", ((IClientSession)this.getModel()).getDesktop());
        return json;
    }

    @Override
    protected void handleModelPropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("locale".equals(propertyName)) {
            this.getUiSession().sendLocaleChangedEvent((Locale)newValue);
        } else {
            super.handleModelPropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void handleModelSessionEvent(SessionEvent event) {
        switch (event.getType()) {
            case 105: {
                this.handleModelSessionStopping();
            }
        }
    }

    protected void handleModelSessionStopping() {
        this.getUiSession().logout();
    }

    protected class P_SessionListener
    implements ISessionListener {
        protected P_SessionListener() {
        }

        public void sessionChanged(SessionEvent event) {
            JsonClientSession.this.handleModelSessionEvent(event);
        }
    }
}

