/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;

public class JsonDate
implements IJsonObject {
    public static final String JSON_PATTERN_FULL = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String JSON_PATTERN_DATE_ONLY = "yyyy-MM-dd";
    public static final String JSON_PATTERN_TIME_ONLY = "HH:mm:ss.SSS";
    public static final String UTC_MARKER = "Z";
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private Date m_javaDate = null;
    private String m_jsonString = null;

    public JsonDate(Date javaDate) {
        this.m_javaDate = javaDate;
    }

    public JsonDate(String jsonString) {
        this.m_jsonString = jsonString;
    }

    public final Date getJavaDate() {
        return this.m_javaDate;
    }

    public final String getJsonString() {
        return this.m_jsonString;
    }

    @Override
    public Object toJson() {
        return this.asJsonString();
    }

    public String asJsonString() {
        return this.asJsonString(false);
    }

    public String asJsonString(boolean utc) {
        return this.asJsonString(utc, true, true);
    }

    public String asJsonString(boolean utc, boolean date, boolean time) {
        if (!date && !time) {
            return null;
        }
        if (this.m_javaDate != null) {
            String pattern = JSON_PATTERN_FULL;
            if (!date) {
                pattern = JSON_PATTERN_TIME_ONLY;
            } else if (!time) {
                pattern = JSON_PATTERN_DATE_ONLY;
            }
            this.m_jsonString = JsonDate.format(this.m_javaDate, pattern, utc);
        }
        return this.m_jsonString;
    }

    public Date asJavaDate() {
        if (this.m_jsonString != null) {
            String pattern = JSON_PATTERN_FULL;
            if (this.m_jsonString.matches("[\\d-]+Z?")) {
                pattern = JSON_PATTERN_DATE_ONLY;
            } else if (this.m_jsonString.matches("[\\d:.]+Z?")) {
                pattern = JSON_PATTERN_TIME_ONLY;
            }
            this.m_javaDate = JsonDate.parse(this.m_jsonString, pattern);
        }
        return this.m_javaDate;
    }

    public static String format(Date date) {
        return JsonDate.format(date, JSON_PATTERN_FULL, false);
    }

    public static String format(Date date, String pattern, boolean utc) {
        if (date == null || pattern == null) {
            return null;
        }
        Locale loc = NlsLocale.get();
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, loc);
        if (utc) {
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return String.valueOf(sdf.format(date)) + (utc ? UTC_MARKER : "");
    }

    public static Date parse(String input, String pattern) {
        if (StringUtility.isNullOrEmpty((CharSequence)input) || pattern == null) {
            return null;
        }
        try {
            Locale loc = NlsLocale.get();
            SimpleDateFormat sdf = new SimpleDateFormat(pattern, loc);
            if (input.endsWith(UTC_MARKER)) {
                sdf.setTimeZone(UTC);
                input = input.substring(0, input.length() - UTC_MARKER.length());
            }
            return sdf.parse(input);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("parse(\"" + input + "\", \"" + pattern + "\") failed", e);
        }
    }
}

