/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.JsonObjectUtility;
import org.json.JSONObject;

public class JsonEvent
implements IJsonObject {
    public static final String TARGET = "target";
    public static final String TYPE = "type";
    private final String m_target;
    private final String m_type;
    private final String m_reference;
    private final JSONObject m_data;
    private volatile boolean m_protected;

    public JsonEvent(String target, String type, String reference, JSONObject data) {
        if (target == null) {
            throw new IllegalArgumentException("Argument 'target' must be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' must be null");
        }
        if (data == null) {
            data = new JSONObject();
        }
        this.m_target = target;
        this.m_type = type;
        this.m_reference = reference;
        this.m_data = data;
    }

    public JsonEvent(String target, String type, JSONObject data) {
        this(target, type, null, data);
    }

    public String getTarget() {
        return this.m_target;
    }

    public String getType() {
        return this.m_type;
    }

    public String getReference() {
        return this.m_reference;
    }

    public JSONObject getData() {
        return this.m_data;
    }

    public boolean isProtected() {
        return this.m_protected;
    }

    public void protect() {
        this.m_protected = true;
    }

    public static JsonEvent fromJson(JSONObject json) {
        if (json == null) {
            throw new IllegalArgumentException("Argument 'json' must not be null");
        }
        String target = json.getString(TARGET);
        String type = json.getString(TYPE);
        JSONObject data = new JSONObject(json.toString());
        data.remove(TARGET);
        data.remove(TYPE);
        return new JsonEvent(target, type, data);
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put(TARGET, (Object)this.m_target);
        json.put(TYPE, (Object)this.m_type);
        JsonObjectUtility.putProperties(json, this.m_data);
        return json;
    }

    public String toString() {
        return "Target: " + this.m_target + ". Type: " + this.m_type + (this.m_reference == null ? "" : ". Reference: " + this.m_reference) + ". Data: " + this.m_data;
    }

    public String toSafeString() {
        String dataKeys = "";
        if (this.m_data != null) {
            dataKeys = this.m_data.keySet().toString();
        }
        return "Target: " + this.m_target + ". Type: " + this.m_type + (this.m_reference == null ? "" : ". Reference: " + this.m_reference) + ". Data-Keys: " + dataKeys;
    }
}

