/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonRequest;
import org.eclipse.scout.rt.ui.html.json.JsonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonEventProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(JsonEventProcessor.class);
    private final IUiSession m_uiSession;

    public JsonEventProcessor(IUiSession uiSession) {
        this.m_uiSession = uiSession;
    }

    public void processEvents(JsonRequest request, JsonResponse response) {
        Assertions.assertTrue((boolean)ModelJobs.isModelThread(), (String)"Event processing must be called from the model thread  [currentThread={}, request={}, response={}]", (Object[])new Object[]{Thread.currentThread().getName(), request, response});
        for (JsonEvent event : request.getEvents()) {
            this.processEvent(event, response);
        }
    }

    protected void processEvent(JsonEvent event, JsonResponse response) {
        IJsonAdapter<?> jsonAdapter = this.m_uiSession.getJsonAdapter(event.getTarget());
        if (jsonAdapter == null) {
            LOG.info("No adapter found for event. {}", (Object)event.toSafeString());
            return;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Handling event '{}' for adapter with ID {}", (Object)event.getType(), (Object)event.getTarget());
            }
            jsonAdapter.handleUiEvent(event);
            jsonAdapter.cleanUpEventFilters();
        }
        catch (PlatformException e) {
            throw e.withContextInfo("ui.event", (Object)event.getType(), new Object[0]).withContextInfo("ui.adapter", jsonAdapter, new Object[0]);
        }
    }
}

