/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;

public abstract class JsonProperty<MODEL_ELEMENT> {
    private final String m_propertyName;
    private final MODEL_ELEMENT m_model;
    private IJsonAdapter<?> m_parentJsonAdapter;
    private final List<JsonProperty<?>> m_lazyProperties = new LinkedList();
    private boolean m_valueSent;

    public JsonProperty(String propertyName, MODEL_ELEMENT model) {
        this.m_propertyName = propertyName;
        this.m_model = model;
    }

    public String getPropertyName() {
        return this.m_propertyName;
    }

    public String jsonPropertyName() {
        return this.getPropertyName();
    }

    protected MODEL_ELEMENT getModel() {
        return this.m_model;
    }

    public void setParentJsonAdapter(IJsonAdapter<?> parentJsonAdapter) {
        this.m_parentJsonAdapter = parentJsonAdapter;
    }

    public IJsonAdapter<?> getParentJsonAdapter() {
        return this.m_parentJsonAdapter;
    }

    public void addLazyProperty(JsonProperty<?> property) {
        this.m_lazyProperties.add(property);
    }

    public List<JsonProperty<?>> getLazyProperties() {
        return this.m_lazyProperties;
    }

    public void setValueSent(boolean valueSent) {
        this.m_valueSent = valueSent;
    }

    public boolean isValueSent() {
        return this.m_valueSent;
    }

    public boolean accept() {
        return true;
    }

    protected abstract Object modelValue();

    public Object prepareValueForToJson(Object value) {
        return value;
    }

    public Object valueToJson() {
        return this.prepareValueForToJson(this.modelValue());
    }

    public void handlePropertyChange(Object oldValue, Object newValue) {
    }

    public void attachChildAdapters() {
    }

    public String toString() {
        return String.valueOf(this.m_propertyName) + ": " + this.m_model;
    }
}

