/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonEventType;
import org.json.JSONObject;

public class JsonPropertyChangeEvent
extends JsonEvent {
    private final Map<String, Object> m_properties = new LinkedHashMap<String, Object>();

    public JsonPropertyChangeEvent(String target) {
        super(target, JsonEventType.PROPERTY.getEventType(), null);
    }

    @Override
    public JSONObject getData() {
        return super.getData();
    }

    public Map<String, Object> getProperties() {
        return this.m_properties;
    }

    @Override
    public JSONObject toJson() {
        JSONObject properties = new JSONObject();
        for (Map.Entry<String, Object> entry : this.m_properties.entrySet()) {
            String propertyName = entry.getKey();
            Object newValue = entry.getValue();
            if (newValue instanceof IJsonObject) {
                newValue = ((IJsonObject)newValue).toJson();
            }
            properties.put(propertyName, newValue == null ? JSONObject.NULL : newValue);
        }
        JSONObject json = super.toJson();
        json.put("properties", (Object)properties);
        return json;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ". Properties: " + this.m_properties;
    }
}

