/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonObjectUtility;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRequest {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRequest.class);
    public static final ThreadLocal<JsonRequest> CURRENT = new ThreadLocal();
    public static final String PROP_STARTUP = "startup";
    public static final String PROP_UNLOAD = "unload";
    public static final String PROP_LOG = "log";
    public static final String PROP_POLL = "pollForBackgroundJobs";
    public static final String PROP_CANCEL = "cancel";
    public static final String PROP_PING = "ping";
    public static final String PROP_SYNC_RESPONSE_QUEUE = "syncResponseQueue";
    public static final String PROP_UI_SESSION_ID = "uiSessionId";
    public static final String PROP_EVENTS = "events";
    public static final String PROP_EVENT = "event";
    public static final String PROP_MESSAGE = "message";
    public static final String PROP_SEQUENCE_NO = "#";
    public static final String PROP_ACK_SEQUENCE_NO = "#ACK";
    private final JSONObject m_request;
    private final RequestType m_requestType;

    public JsonRequest(JSONObject request) {
        RequestType requestType = RequestType.valueOf(request);
        this.validate(requestType, request);
        this.m_requestType = requestType;
        this.m_request = request;
    }

    protected void validate(RequestType requestType, JSONObject request) {
        if (!ObjectUtility.isOneOf((Object)((Object)requestType), (Object)((Object)RequestType.STARTUP_REQUEST), (Object[])new Object[]{RequestType.PING_REQUEST})) {
            Assertions.assertTrue((boolean)request.has(PROP_UI_SESSION_ID), (String)"Missing property '{}' in request {}", (Object[])new Object[]{PROP_UI_SESSION_ID, request});
        }
        if (requestType != RequestType.REQUEST && request.has(PROP_EVENTS)) {
            request.remove(PROP_EVENTS);
            String requestAsString = request.toString();
            if (requestAsString.length() > 10000) {
                requestAsString = String.valueOf(requestAsString.substring(0, 10000)) + "...";
            }
            LOG.info("Request contains unexpected attribute '{}': {}", (Object)PROP_EVENTS, (Object)requestAsString);
        }
    }

    protected JSONObject getRequestObject() {
        return this.m_request;
    }

    public String getUiSessionId() {
        return this.m_request.optString(PROP_UI_SESSION_ID, null);
    }

    public List<JsonEvent> getEvents() {
        JSONArray events = this.m_request.optJSONArray(PROP_EVENTS);
        if (events == null) {
            return new ArrayList<JsonEvent>(0);
        }
        ArrayList<JsonEvent> actionList = new ArrayList<JsonEvent>(events.length());
        int i = 0;
        while (i < events.length()) {
            JSONObject json = events.getJSONObject(i);
            actionList.add(JsonEvent.fromJson(json));
            ++i;
        }
        return actionList;
    }

    public RequestType getRequestType() {
        return this.m_requestType;
    }

    public JSONObject getEvent() {
        return this.m_request.optJSONObject(PROP_EVENT);
    }

    public String getMessage() {
        return this.m_request.optString(PROP_MESSAGE, null);
    }

    public Long getAckSequenceNo() {
        return JsonObjectUtility.optLong(this.m_request, PROP_ACK_SEQUENCE_NO);
    }

    public Long getSequenceNo() {
        return JsonObjectUtility.optLong(this.m_request, PROP_SEQUENCE_NO);
    }

    public String toString() {
        return JsonObjectUtility.toString(this.m_request);
    }

    public static enum RequestType {
        REQUEST,
        STARTUP_REQUEST,
        UNLOAD_REQUEST,
        POLL_REQUEST,
        CANCEL_REQUEST,
        PING_REQUEST,
        LOG_REQUEST,
        SYNC_RESPONSE_QUEUE;


        public static RequestType valueOf(String string) {
            return Enum.valueOf(RequestType.class, string);
        }
    }
}

