/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import org.eclipse.scout.rt.platform.status.IMultiStatus;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.status.Status;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.MainJsonObjectFactory;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.json.JSONObject;

public class JsonStatus
implements IJsonObject {
    private final IStatus m_status;

    public JsonStatus(IStatus status) {
        this.m_status = status;
    }

    public String getObjectType() {
        return "Status";
    }

    public IStatus getStatus() {
        return this.m_status;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("objectType", (Object)this.getObjectType());
        json.put("message", (Object)this.m_status.getMessage());
        json.put("severity", this.m_status.getSeverity());
        json.put("iconId", (Object)BinaryResourceUrlUtility.createIconUrl(this.m_status.getIconId()));
        json.put("code", this.m_status.getCode());
        if (this.m_status.isMultiStatus()) {
            for (IStatus cs : ((IMultiStatus)this.m_status).getChildren()) {
                json.append("children", MainJsonObjectFactory.get().createJsonObject(cs).toJson());
            }
        }
        return json;
    }

    public static JSONObject toJson(IStatus status) {
        if (status == null) {
            return null;
        }
        return new JsonStatus(status).toJson();
    }

    public static IStatus toScoutObject(JSONObject jsonStatus) {
        if (jsonStatus == null) {
            return null;
        }
        String message = jsonStatus.optString("message");
        int severity = jsonStatus.getInt("severity");
        String iconId = jsonStatus.optString("iconId");
        Integer code = jsonStatus.optInt("code");
        Status status = new Status(message, severity);
        if (iconId != null) {
            status.withIconId(iconId);
        }
        if (code != null) {
            status.withCode(code.intValue());
        }
        return status;
    }
}

