/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.ui.html.AbstractUiServletRequestHandler;
import org.eclipse.scout.rt.ui.html.HttpSessionHelper;
import org.eclipse.scout.rt.ui.html.ISessionStore;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=5500.0)
public class UnloadRequestHandler
extends AbstractUiServletRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UnloadRequestHandler.class);
    public static final Pattern UNLOAD_PATH_PATTERN = Pattern.compile("^/unload/(.+)$");

    @Override
    public boolean handlePost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pathInfo = req.getPathInfo();
        Matcher matcher = UNLOAD_PATH_PATTERN.matcher(pathInfo);
        if (!matcher.matches()) {
            return false;
        }
        String uiSessionId = matcher.group(1);
        this.handleUnloadRequest(req, resp, uiSessionId);
        return true;
    }

    protected void handleUnloadRequest(HttpServletRequest req, HttpServletResponse resp, String uiSessionId) {
        LOG.info("Unloading UI session with ID {} (requested by UI)", (Object)uiSessionId);
        HttpSession httpSession = req.getSession();
        ISessionStore sessionStore = ((HttpSessionHelper)BEANS.get(HttpSessionHelper.class)).getSessionStore(httpSession);
        IUiSession uiSession = sessionStore.getUiSession(uiSessionId);
        if (uiSession != null) {
            ReentrantLock uiSessionLock = uiSession.uiSessionLock();
            uiSessionLock.lock();
            try {
                uiSession.dispose();
            }
            finally {
                uiSessionLock.unlock();
            }
        }
    }
}

