/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.action;

import java.beans.PropertyChangeEvent;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonWidget;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.JsonResponse;
import org.eclipse.scout.rt.ui.html.json.action.DisplayableActionFilter;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfig;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfigBuilder;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceHolder;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceProvider;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonAction<ACTION extends IAction>
extends AbstractJsonWidget<ACTION>
implements IBinaryResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JsonAction.class);
    public static final String EVENT_ACTION = "action";

    public JsonAction(ACTION model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "Action";
    }

    @Override
    protected void initJsonProperties(ACTION model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<ACTION>("text", (IAction)model){

            @Override
            protected String modelValue() {
                return ((IAction)this.getModel()).getText();
            }
        });
        this.putJsonProperty(new JsonProperty<ACTION>("textPosition", (IAction)model){

            @Override
            protected String modelValue() {
                return ((IAction)this.getModel()).getTextPosition();
            }
        });
        this.putJsonProperty(new JsonProperty<ACTION>("htmlEnabled", (IAction)model){

            @Override
            protected Boolean modelValue() {
                return ((IAction)this.getModel()).isHtmlEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<ACTION>("tooltipText", (IAction)model){

            @Override
            protected String modelValue() {
                return ((IAction)this.getModel()).getTooltipText();
            }
        });
        this.putJsonProperty(new JsonProperty<ACTION>("toggleAction", (IAction)model){

            @Override
            protected Boolean modelValue() {
                return ((IAction)this.getModel()).isToggleAction();
            }
        });
        this.putJsonProperty(new JsonProperty<ACTION>("selected", (IAction)model){

            @Override
            protected Boolean modelValue() {
                return ((IAction)this.getModel()).isSelected();
            }
        });
        this.putJsonProperty(new JsonProperty<ACTION>("visible", (IAction)model){

            @Override
            protected Boolean modelValue() {
                return ((IAction)this.getModel()).isVisible();
            }
        });
        this.putJsonProperty(new JsonProperty<ACTION>("keyStroke", (IAction)model){

            @Override
            protected String modelValue() {
                return ((IAction)this.getModel()).getKeyStroke();
            }
        });
        this.putJsonProperty(new JsonProperty<ACTION>("keyStrokeFirePolicy", (IAction)model){

            @Override
            protected Integer modelValue() {
                return ((IAction)this.getModel()).getKeyStrokeFirePolicy();
            }
        });
        this.putJsonProperty(new JsonProperty<ACTION>("horizontalAlignment", (IAction)model){

            @Override
            protected Integer modelValue() {
                return ((IAction)this.getModel()).getHorizontalAlignment();
            }
        });
        this.putJsonProperty(new JsonProperty<ACTION>("actionStyle", (IAction)model){

            @Override
            protected Integer modelValue() {
                return ((IAction)this.getModel()).getActionStyle();
            }
        });
        this.putJsonProperty(new JsonAdapterProperty<ACTION>("childActions", (IAction)model, this.getUiSession()){

            @Override
            protected JsonAdapterPropertyConfig createConfig() {
                return new JsonAdapterPropertyConfigBuilder().filter(new DisplayableActionFilter()).build();
            }

            @Override
            protected Object modelValue() {
                if (this.getModel() instanceof IActionNode) {
                    return ((IActionNode)this.getModel()).getChildActions();
                }
                return null;
            }
        });
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        json.put("iconId", (Object)this.getIconDesc());
        return json;
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_ACTION.equals(event.getType())) {
            this.handleUiAction(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiAction(JsonEvent event) {
        ((IAction)this.getModel()).getUIFacade().fireActionFromUI();
    }

    @Override
    protected void handleUiPropertyChange(String propertyName, JSONObject data) {
        if ("selected".equals(propertyName)) {
            boolean selected = data.getBoolean(propertyName);
            this.addPropertyEventFilterCondition(propertyName, selected);
            ((IAction)this.getModel()).getUIFacade().setSelectedFromUI(selected);
        } else {
            super.handleUiPropertyChange(propertyName, data);
        }
    }

    @Override
    protected void handleModelPropertyChange(PropertyChangeEvent event) {
        if ("visible".equals(event.getPropertyName()) && !((IAction)this.getModel()).isVisibleGranted()) {
            JsonResponse response = this.getUiSession().currentJsonResponse();
            if (response.containsAdapter(this) && response.isWritable()) {
                this.dispose();
                return;
            }
            LOG.warn("Setting visibleGranted=false has no effect, because JsonAdapter {} ({}) is already sent to the UI.", (Object)this.getId(), this.getModel());
        }
        super.handleModelPropertyChange(event);
    }

    @Override
    protected void handleModelPropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (ObjectUtility.isOneOf((Object)propertyName, (Object)"iconId", (Object[])new Object[]{"image"})) {
            this.handleModelIIconSourceChanged();
        } else {
            super.handleModelPropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void handleModelIIconSourceChanged() {
        this.addPropertyChangeEvent("iconId", (Object)this.getIconDesc());
    }

    protected String getIconDesc() {
        BinaryResource imageResource;
        if (((IAction)this.getModel()).getImage() != null && (imageResource = BinaryResourceUrlUtility.extractBinaryResource(((IAction)this.getModel()).getImage(), "image", "jpg")) != null && imageResource.getContent() != null) {
            return BinaryResourceUrlUtility.createDynamicAdapterResourceUrl(this, imageResource);
        }
        return BinaryResourceUrlUtility.createIconUrl(((IAction)this.getModel()).getIconId());
    }

    @Override
    public BinaryResourceHolder provideBinaryResource(String requestFilename) {
        BinaryResource image = BinaryResourceUrlUtility.extractBinaryResource(((IAction)this.getModel()).getImage(), "image", "jpg");
        if (image == null || image.getContent() == null) {
            return null;
        }
        String imageFilenameWithFingerprint = BinaryResourceUrlUtility.getFilenameWithFingerprint(image);
        if (imageFilenameWithFingerprint.equals(requestFilename)) {
            return new BinaryResourceHolder(image);
        }
        return null;
    }
}

