/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.basic.cell;

import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.JsonObjectUtility;
import org.eclipse.scout.rt.ui.html.json.JsonStatus;
import org.eclipse.scout.rt.ui.html.json.basic.cell.ICellValueReader;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.json.JSONObject;

public class JsonCell
implements IJsonObject {
    private final ICell m_cell;
    private final String m_cellText;
    private final IJsonAdapter<?> m_parentAdapter;
    private Object m_cellValue;
    private final Integer m_cellSortCode;

    public JsonCell(ICell cell, IJsonAdapter<?> parentAdapter) {
        this(cell, parentAdapter, null);
    }

    public JsonCell(ICell cell, IJsonAdapter<?> parentAdapter, ICellValueReader cellValueReader) {
        this(cell, parentAdapter, cellValueReader, null);
    }

    public JsonCell(ICell cell, IJsonAdapter<?> parentAdapter, ICellValueReader cellValueReader, Integer cellSortCode) {
        this.m_cell = cell;
        this.m_cellText = cell.getText();
        this.m_parentAdapter = parentAdapter;
        if (cellValueReader != null) {
            this.m_cellValue = cellValueReader.read();
        }
        this.m_cellSortCode = cellSortCode;
    }

    public final ICell getCell() {
        return this.m_cell;
    }

    public final Object getCellValue() {
        return this.m_cellValue;
    }

    public final String getCellText() {
        return this.m_cellText;
    }

    public final Integer getCellSortCode() {
        return this.m_cellSortCode;
    }

    public JSONObject toJson() {
        if (this.m_cell == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put("value", this.m_cellValue);
        if (this.getCell().isHtmlEnabled()) {
            json.put("text", (Object)BinaryResourceUrlUtility.replaceImageUrls(this.m_parentAdapter, this.m_cellText));
        } else {
            json.put("text", (Object)this.m_cellText);
        }
        json.put("iconId", (Object)BinaryResourceUrlUtility.createIconUrl(this.m_cell.getIconId()));
        json.put("tooltipText", (Object)this.m_cell.getTooltipText());
        if (this.m_cell.getErrorStatus() != null && this.m_cell.getErrorStatus().getSeverity() == 0x1000000) {
            json.put("errorStatus", (Object)JsonStatus.toJson((IStatus)this.m_cell.getErrorStatus()));
        }
        json.put("cssClass", (Object)this.m_cell.getCssClass());
        json.put("horizontalAlignment", this.m_cell.getHorizontalAlignment());
        json.put("foregroundColor", (Object)this.m_cell.getForegroundColor());
        json.put("backgroundColor", (Object)this.m_cell.getBackgroundColor());
        json.put("font", this.m_cell.getFont() == null ? null : this.m_cell.getFont().toPattern());
        json.put("editable", this.m_cell.isEditable());
        json.put("htmlEnabled", this.m_cell.isHtmlEnabled());
        json.put("mandatory", this.m_cell.isMandatory());
        if (this.getCellSortCode() != null) {
            json.put("sortCode", (Object)this.getCellSortCode());
        }
        return json;
    }

    public Object toJsonOrString() {
        JSONObject json = this.toJson();
        JsonObjectUtility.filterDefaultValues(json, "Cell");
        String text = json.optString("text");
        Object value = json.opt("value");
        if (JSONObject.NULL.equals(value) && StringUtility.isNullOrEmpty((CharSequence)text)) {
            json.remove("value");
        }
        if (json.length() == 1 && json.has("text")) {
            return text;
        }
        return json;
    }
}

