/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.basic.filechooser;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.FileUtility;

@Bean
public class JsonFileChooserAcceptAttributeBuilder {
    private final Map<String, String> m_mimeTypeToAcceptType = new HashMap<String, String>();

    public JsonFileChooserAcceptAttributeBuilder withTypes(Collection<String> mimeTypeOrExtensions) {
        if (mimeTypeOrExtensions != null) {
            for (String t : mimeTypeOrExtensions) {
                this.withType(t);
            }
        }
        return this;
    }

    public JsonFileChooserAcceptAttributeBuilder withType(String mimeTypeOrExtension) {
        if (mimeTypeOrExtension != null) {
            if (mimeTypeOrExtension.indexOf(47) > -1) {
                this.m_mimeTypeToAcceptType.put(mimeTypeOrExtension, this.convertToAcceptType(mimeTypeOrExtension, null));
            } else {
                String mimeType;
                String ext = mimeTypeOrExtension;
                if (ext.startsWith("*")) {
                    ext = ext.substring(1);
                }
                if (ext.startsWith(".")) {
                    ext = ext.substring(1);
                }
                if ((mimeType = FileUtility.getContentTypeForExtension((String)ext)) == null) {
                    mimeType = ext;
                }
                this.m_mimeTypeToAcceptType.put(mimeType, this.convertToAcceptType(mimeType, ext));
            }
        }
        return this;
    }

    public Set<String> build() {
        return new HashSet<String>(this.m_mimeTypeToAcceptType.values());
    }

    protected String convertToAcceptType(String mimeType, String ext) {
        block17: {
            switch (mimeType) {
                case "text/comma-separated-values": 
                case "text/csv": {
                    return ".csv";
                }
            }
            if (ext == null) break block17;
            switch (ext) {
                case "csv": {
                    return ".csv";
                }
            }
        }
        return mimeType;
    }
}

