/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.basic.planner;

import org.eclipse.scout.rt.client.ui.basic.planner.Activity;
import org.eclipse.scout.rt.ui.html.json.IIdProvider;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.JsonDate;
import org.eclipse.scout.rt.ui.html.json.JsonObjectUtility;
import org.json.JSONObject;

public class JsonActivity
implements IJsonObject {
    private final IIdProvider<Activity<?, ?>> m_idProvider;
    private final Activity<?, ?> m_activity;

    public JsonActivity(Activity<?, ?> cell, IIdProvider<Activity<?, ?>> idProvider) {
        this.m_activity = cell;
        this.m_idProvider = idProvider;
    }

    public Activity<?, ?> getActivityCell() {
        return this.m_activity;
    }

    public JSONObject toJson() {
        if (this.m_activity == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.m_idProvider.getId(this.m_activity));
        json.put("beginTime", (Object)new JsonDate(this.m_activity.getBeginTime()).asJsonString());
        json.put("endTime", (Object)new JsonDate(this.m_activity.getEndTime()).asJsonString());
        json.put("text", (Object)this.m_activity.getText());
        json.put("backgroundColor", (Object)this.m_activity.getBackgroundColor());
        json.put("foregroundColor", (Object)this.m_activity.getForegroundColor());
        json.put("level", (double)this.m_activity.getLevel());
        json.put("levelColor", (Object)this.m_activity.getLevelColor());
        json.put("tooltipText", (Object)this.m_activity.getTooltipText());
        json.put("cssClass", (Object)this.m_activity.getCssClass());
        JsonObjectUtility.filterDefaultValues(json, "Activity");
        return json;
    }
}

