/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.basic.planner;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.AbstractEventBuffer;
import org.eclipse.scout.rt.client.ui.IModelEvent;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.IPlannerContextMenu;
import org.eclipse.scout.rt.client.ui.basic.planner.Activity;
import org.eclipse.scout.rt.client.ui.basic.planner.DisplayModeOptions;
import org.eclipse.scout.rt.client.ui.basic.planner.IPlanner;
import org.eclipse.scout.rt.client.ui.basic.planner.PlannerAdapter;
import org.eclipse.scout.rt.client.ui.basic.planner.PlannerEvent;
import org.eclipse.scout.rt.client.ui.basic.planner.PlannerListener;
import org.eclipse.scout.rt.client.ui.basic.planner.Resource;
import org.eclipse.scout.rt.platform.util.Range;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonWidget;
import org.eclipse.scout.rt.ui.html.json.FilteredJsonAdapterIds;
import org.eclipse.scout.rt.ui.html.json.IIdProvider;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonDate;
import org.eclipse.scout.rt.ui.html.json.JsonDateRange;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.MainJsonObjectFactory;
import org.eclipse.scout.rt.ui.html.json.basic.planner.JsonResource;
import org.eclipse.scout.rt.ui.html.json.basic.planner.PlannerEventFilter;
import org.eclipse.scout.rt.ui.html.json.basic.planner.PlannerEventFilterCondition;
import org.eclipse.scout.rt.ui.html.json.menu.IJsonContextMenuOwner;
import org.eclipse.scout.rt.ui.html.json.menu.JsonContextMenu;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPlanner<PLANNER extends IPlanner<?, ?>>
extends AbstractJsonWidget<PLANNER>
implements IJsonContextMenuOwner {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPlanner.class);
    public static final String PROP_RESOURCE_IDS = "resourceIds";
    public static final String EVENT_PLANNER_CHANGED = "plannerChanged";
    public static final String EVENT_RESOURCES_INSERTED = "resourcesInserted";
    public static final String EVENT_RESOURCES_UPDATED = "resourcesUpdated";
    public static final String EVENT_RESOURCES_DELETED = "resourcesDeleted";
    public static final String EVENT_RESOURCES_SELECTED = "resourcesSelected";
    public static final String EVENT_ALL_RESOURCES_DELETED = "allResourcesDeleted";
    private PlannerListener m_plannerListener;
    private final Map<String, Activity<?, ?>> m_activities = new HashMap();
    private final Map<Activity<?, ?>, String> m_activityIds = new HashMap();
    private final Map<String, Resource<?>> m_resources = new HashMap();
    private final Map<Resource<?>, String> m_resourceIds = new HashMap();
    private final AbstractEventBuffer<PlannerEvent> m_eventBuffer;
    private final PlannerEventFilter m_plannerEventFilter;
    private JsonContextMenu<IContextMenu> m_jsonContextMenu;

    public JsonPlanner(PLANNER model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
        this.m_eventBuffer = model.createEventBuffer();
        this.m_plannerEventFilter = new PlannerEventFilter(this);
    }

    @Override
    public String getObjectType() {
        return "Planner";
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        if (this.m_plannerListener != null) {
            throw new IllegalStateException();
        }
        this.m_plannerListener = new P_PlannerListener();
        ((IPlanner)this.getModel()).addPlannerListener(this.m_plannerListener);
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        if (this.m_plannerListener == null) {
            throw new IllegalStateException();
        }
        ((IPlanner)this.getModel()).removePlannerListener(this.m_plannerListener);
        this.m_plannerListener = null;
    }

    @Override
    protected void attachChildAdapters() {
        super.attachChildAdapters();
        this.m_jsonContextMenu = new JsonContextMenu<IPlannerContextMenu>(((IPlanner)this.getModel()).getContextMenu(), this);
        this.m_jsonContextMenu.init();
    }

    @Override
    protected void disposeChildAdapters() {
        this.m_jsonContextMenu.dispose();
        super.disposeChildAdapters();
    }

    @Override
    protected void initJsonProperties(PLANNER model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<PLANNER>("label", (IPlanner)model){

            @Override
            protected String modelValue() {
                return ((IPlanner)this.getModel()).getLabel();
            }
        });
        this.putJsonProperty(new JsonProperty<PLANNER>("availableDisplayModes", (IPlanner)model){

            @Override
            protected Set<Integer> modelValue() {
                return ((IPlanner)this.getModel()).getAvailableDisplayModes();
            }
        });
        this.putJsonProperty(new JsonProperty<PLANNER>("displayMode", (IPlanner)model){

            @Override
            protected Integer modelValue() {
                return ((IPlanner)this.getModel()).getDisplayMode();
            }
        });
        this.putJsonProperty(new JsonProperty<PLANNER>("displayModeOptions", (IPlanner)model){

            @Override
            protected Map<Integer, DisplayModeOptions> modelValue() {
                return ((IPlanner)this.getModel()).getDisplayModeOptions();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                if (value == null) {
                    return null;
                }
                JSONObject options = new JSONObject();
                for (Map.Entry option : ((Map)value).entrySet()) {
                    options.put(String.valueOf(option.getKey()), MainJsonObjectFactory.get().createJsonObject(option.getValue()).toJson());
                }
                return options;
            }
        });
        this.putJsonProperty(new JsonProperty<PLANNER>("viewRange", (IPlanner)model){

            protected Range<Date> modelValue() {
                return ((IPlanner)this.getModel()).getViewRange();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                if (value == null) {
                    return null;
                }
                return new JsonDateRange((Range<Date>)((Range)value)).toJson();
            }
        });
        this.putJsonProperty(new JsonProperty<PLANNER>("headerVisible", (IPlanner)model){

            @Override
            protected Boolean modelValue() {
                return ((IPlanner)this.getModel()).isHeaderVisible();
            }
        });
        this.putJsonProperty(new JsonProperty<PLANNER>("selectionRange", (IPlanner)model){

            protected Range<Date> modelValue() {
                return ((IPlanner)this.getModel()).getSelectionRange();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                if (value == null) {
                    return null;
                }
                return new JsonDateRange((Range<Date>)((Range)value)).toJson();
            }
        });
        this.putJsonProperty(new JsonProperty<PLANNER>("selectedActivity", (IPlanner)model){

            protected Activity<?, ?> modelValue() {
                return ((IPlanner)this.getModel()).getSelectedActivity();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                Activity activityCell = (Activity)value;
                return new P_GetOrCreateCellIdProvider().getId(activityCell);
            }
        });
        this.putJsonProperty(new JsonProperty<PLANNER>("selectionMode", (IPlanner)model){

            @Override
            protected Integer modelValue() {
                return ((IPlanner)this.getModel()).getSelectionMode();
            }
        });
        this.putJsonProperty(new JsonProperty<PLANNER>("activitySelectable", (IPlanner)model){

            @Override
            protected Boolean modelValue() {
                return ((IPlanner)this.getModel()).isActivitySelectable();
            }
        });
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        List resources = ((IPlanner)this.getModel()).getResources();
        JSONArray jsonResources = new JSONArray();
        for (Resource resource : resources) {
            Object jsonResource = this.resourceToJson(resource, new P_GetOrCreateResourceIdProvider(), new P_GetOrCreateCellIdProvider());
            LOG.debug("Id: {}. Resources: {}", (Object)this.getId(), jsonResource);
            jsonResources.put(jsonResource);
        }
        json.put("resources", (Object)jsonResources);
        json.put("menus", (Object)this.m_jsonContextMenu.childActionsToJson());
        this.putProperty(json, "selectedResources", this.resourceIdsToJson(((IPlanner)this.getModel()).getSelectedResources(), new P_ResourceIdProvider()));
        return json;
    }

    protected String getCellId(Activity<?, ?> cell) {
        return this.m_activityIds.get(cell);
    }

    protected String createCellId(Activity<?, ?> cell) {
        String id = this.getCellId(cell);
        if (id != null) {
            throw new IllegalStateException("Cell already has an id. " + cell);
        }
        id = this.getUiSession().createUniqueId();
        this.m_activities.put(id, cell);
        this.m_activityIds.put(cell, id);
        return id;
    }

    protected String getResourceId(Resource<?> resource) {
        if (resource == null) {
            return null;
        }
        return this.m_resourceIds.get(resource);
    }

    protected Resource<?> getResource(String id) {
        if (id == null) {
            return null;
        }
        return this.m_resources.get(id);
    }

    protected String getActivityId(Activity<?, ?> activity) {
        if (activity == null) {
            return null;
        }
        return this.m_activityIds.get(activity);
    }

    protected Activity<?, ?> getActivity(String id) {
        if (id == null) {
            return null;
        }
        return this.m_activities.get(id);
    }

    protected String createResourceId(Resource<?> resource) {
        String id = this.getResourceId(resource);
        if (id != null) {
            throw new IllegalStateException("Resource already has an id. " + resource);
        }
        id = this.getUiSession().createUniqueId();
        this.m_resources.put(id, resource);
        this.m_resourceIds.put(resource, id);
        return id;
    }

    protected void disposeResource(Resource<?> resource) {
        String resourceId = this.m_resourceIds.remove(resource);
        this.m_resources.remove(resourceId);
        for (Activity activity : resource.getActivities()) {
            String activityId = this.m_activityIds.remove(activity);
            this.m_activities.remove(activityId);
        }
    }

    protected void disposeAllResources() {
        this.m_resourceIds.clear();
        this.m_resources.clear();
        this.m_activityIds.clear();
        this.m_activities.clear();
    }

    protected void handleModelEvent(PlannerEvent event) {
        if ((event = this.m_plannerEventFilter.filter(event)) == null) {
            return;
        }
        this.m_eventBuffer.add((IModelEvent)event);
        this.registerAsBufferedEventsAdapter();
    }

    @Override
    public void processBufferedEvents() {
        if (this.m_eventBuffer.isEmpty()) {
            return;
        }
        List coalescedEvents = this.m_eventBuffer.consumeAndCoalesceEvents();
        for (PlannerEvent event : coalescedEvents) {
            this.processEvent(event);
        }
    }

    protected void processEvent(PlannerEvent event) {
        switch (event.getType()) {
            case 100: {
                this.handleModelResourcesInserted(event.getResources());
                break;
            }
            case 101: {
                this.handleModelResourcesUpdated(event.getResources());
                break;
            }
            case 102: {
                this.handleModelResourcesDeleted(event.getResources());
                break;
            }
            case 103: {
                this.handleModelResourcesSelected(event.getResources());
                break;
            }
            case 105: {
                this.handleModelAllResourcesDeleted();
            }
        }
    }

    protected void handleModelResourcesSelected(List<? extends Resource> resources) {
        JSONObject jsonEvent = new JSONObject();
        this.putProperty(jsonEvent, PROP_RESOURCE_IDS, this.resourceIdsToJson(resources, new P_ResourceIdProvider()));
        this.addActionEvent(EVENT_RESOURCES_SELECTED, jsonEvent);
    }

    protected void handleModelResourcesInserted(List<? extends Resource> resources) {
        JSONArray jsonResources = new JSONArray();
        for (Resource resource : resources) {
            Object jsonResource = new JsonResource(resource, this, new P_NewResourceIdProvider(), new P_NewCellIdProvider()).toJson();
            jsonResources.put(jsonResource);
        }
        if (jsonResources.length() == 0) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("resources", (Object)jsonResources);
        this.addActionEvent(EVENT_RESOURCES_INSERTED, jSONObject);
    }

    protected void handleModelResourcesUpdated(List<? extends Resource> resources) {
        JSONArray jsonResources = new JSONArray();
        for (Resource resource : resources) {
            Object jsonResource = this.resourceToJson(resource, new P_GetOrCreateResourceIdProvider(), new P_GetOrCreateCellIdProvider());
            jsonResources.put(jsonResource);
        }
        JSONObject jSONObject = new JSONObject();
        this.putProperty(jSONObject, "resources", jsonResources);
        this.addActionEvent(EVENT_RESOURCES_UPDATED, jSONObject);
    }

    protected void handleModelResourcesDeleted(List<? extends Resource> resources) {
        if (resources.isEmpty()) {
            return;
        }
        JSONObject jsonEvent = new JSONObject();
        for (Resource resource : resources) {
            String resourceId = this.getResourceId(resource);
            jsonEvent.append(PROP_RESOURCE_IDS, (Object)resourceId);
            this.disposeResource(resource);
        }
        this.addActionEvent(EVENT_RESOURCES_DELETED, jsonEvent);
    }

    protected void handleModelAllResourcesDeleted() {
        this.disposeAllResources();
        this.addActionEvent(EVENT_ALL_RESOURCES_DELETED, new JSONObject());
    }

    protected void handleModelResourceOrderChanged(List<? extends Resource> resources) {
        JSONObject jsonEvent = new JSONObject();
        jsonEvent.put(PROP_RESOURCE_IDS, (Object)this.resourceIdsToJson(resources, new P_ResourceIdProvider()));
        JSONArray jsonResourceIds = new JSONArray();
        for (Resource resource : resources) {
            String resourceId = this.getResourceId(resource);
            jsonResourceIds.put((Object)resourceId);
        }
        if (jsonResourceIds.length() == 0) {
            return;
        }
        this.addActionEvent("resourceOrderChanged", jsonEvent);
    }

    @Override
    public void handleModelContextMenuChanged(FilteredJsonAdapterIds<?> filteredAdapters) {
        this.addPropertyChangeEvent("menus", filteredAdapters);
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_RESOURCES_SELECTED.equals(event.getType())) {
            this.handleUiResourcesSelected(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiResourcesSelected(JsonEvent event) {
        JSONArray resourceIds = event.getData().getJSONArray(PROP_RESOURCE_IDS);
        List<Resource<?>> resources = this.extractResources(resourceIds);
        if (resources.isEmpty() && resourceIds.length() > 0) {
            return;
        }
        if (resources.size() == resourceIds.length()) {
            this.addPlannerEventFilterCondition(103).setResources(resources);
        }
        ((IPlanner)this.getModel()).getUIFacade().setSelectedResourcesFromUI(resources);
    }

    @Override
    protected void handleUiPropertyChange(String propertyName, JSONObject data) {
        if ("displayMode".equals(propertyName)) {
            this.handleUiDisplayModeChange(data);
        } else if ("viewRange".equals(propertyName)) {
            this.handleUiViewRangeChange(data);
        } else if ("selectedActivity".equals(propertyName)) {
            this.handleUiSelectedActivityChange(data);
        } else if ("selectionRange".equals(propertyName)) {
            this.handleUiSelectionRangeChange(data);
        } else {
            super.handleUiPropertyChange(propertyName, data);
        }
    }

    protected void handleUiSelectedActivityChange(JSONObject data) {
        String activityId = data.optString("selectedActivity", null);
        Activity<?, ?> selectedActivity = this.getActivity(activityId);
        this.addPropertyEventFilterCondition("selectedActivity", selectedActivity);
        ((IPlanner)this.getModel()).getUIFacade().setSelectedActivityFromUI(selectedActivity);
    }

    protected void handleUiSelectionRangeChange(JSONObject data) {
        Range<Date> selectionRange = this.extractSelectionRange(data);
        this.addPropertyEventFilterCondition("selectionRange", selectionRange);
        ((IPlanner)this.getModel()).getUIFacade().setSelectionRangeFromUI(selectionRange);
    }

    protected Range<Date> extractSelectionRange(JSONObject data) {
        JSONObject selectionRange = data.optJSONObject("selectionRange");
        Date fromDate = this.toJavaDate(selectionRange, "from");
        Date toDate = this.toJavaDate(selectionRange, "to");
        return new Range((Object)fromDate, (Object)toDate);
    }

    protected void handleUiDisplayModeChange(JSONObject data) {
        int displayMode = data.getInt("displayMode");
        this.addPropertyEventFilterCondition("displayMode", displayMode);
        ((IPlanner)this.getModel()).getUIFacade().setDisplayModeFromUI(displayMode);
    }

    protected void handleUiViewRangeChange(JSONObject data) {
        Range<Date> viewRange = this.extractViewRange(data);
        this.addPropertyEventFilterCondition("viewRange", viewRange);
        ((IPlanner)this.getModel()).getUIFacade().setViewRangeFromUI(viewRange);
    }

    protected Range<Date> extractViewRange(JSONObject data) {
        JSONObject range = data.optJSONObject("viewRange");
        Date fromDate = this.toJavaDate(range, "from");
        Date toDate = this.toJavaDate(range, "to");
        return new Range((Object)fromDate, (Object)toDate);
    }

    protected Date toJavaDate(JSONObject data, String propertyName) {
        String dateStr = data.optString(propertyName, null);
        if (dateStr == null) {
            return null;
        }
        return new JsonDate(dateStr).asJavaDate();
    }

    protected List<Resource<?>> extractResources(JSONObject json) {
        JSONArray resourceIds = json.getJSONArray(PROP_RESOURCE_IDS);
        return this.extractResources(resourceIds);
    }

    protected List<Resource<?>> extractResources(JSONArray resourceIds) {
        ArrayList resources = new ArrayList(resourceIds.length());
        int i = 0;
        while (i < resourceIds.length()) {
            Resource<?> resource = this.getResource((String)resourceIds.get(i));
            if (resource != null) {
                resources.add(resource);
            }
            ++i;
        }
        return resources;
    }

    protected Object resourceToJson(Resource<?> resource) {
        return new JsonResource(resource, this, new P_NewResourceIdProvider(), new P_NewCellIdProvider()).toJson();
    }

    protected Object resourceToJson(Resource<?> resource, IIdProvider<Resource<?>> idProvider, IIdProvider<Activity<?, ?>> cellIdProvider) {
        return new JsonResource(resource, this, idProvider, cellIdProvider).toJson();
    }

    protected JSONArray resourceIdsToJson(List<? extends Resource> resources, IIdProvider<Resource<?>> idProvider) {
        JSONArray jsonResourceIds = new JSONArray();
        for (Resource resource : resources) {
            String resourceId = idProvider.getId(resource);
            if (resourceId == null) continue;
            jsonResourceIds.put((Object)resourceId);
        }
        return jsonResourceIds;
    }

    protected PlannerEventFilterCondition addPlannerEventFilterCondition(int plannerEventType) {
        PlannerEventFilterCondition condition = new PlannerEventFilterCondition(plannerEventType);
        this.m_plannerEventFilter.addCondition(condition);
        return condition;
    }

    @Override
    public void cleanUpEventFilters() {
        super.cleanUpEventFilters();
        this.m_plannerEventFilter.removeAllConditions();
    }

    protected class P_CellIdProvider
    implements IIdProvider<Activity<?, ?>> {
        protected P_CellIdProvider() {
        }

        @Override
        public String getId(Activity<?, ?> cell) {
            return JsonPlanner.this.getCellId(cell);
        }
    }

    protected class P_GetOrCreateCellIdProvider
    implements IIdProvider<Activity<?, ?>> {
        protected P_GetOrCreateCellIdProvider() {
        }

        @Override
        public String getId(Activity<?, ?> cell) {
            if (cell == null) {
                return null;
            }
            String id = JsonPlanner.this.getCellId(cell);
            if (id == null) {
                id = JsonPlanner.this.createCellId(cell);
            }
            return id;
        }
    }

    protected class P_GetOrCreateResourceIdProvider
    implements IIdProvider<Resource<?>> {
        protected P_GetOrCreateResourceIdProvider() {
        }

        @Override
        public String getId(Resource<?> resource) {
            if (resource == null) {
                return null;
            }
            String id = JsonPlanner.this.getResourceId(resource);
            if (id == null) {
                id = JsonPlanner.this.createResourceId(resource);
            }
            return id;
        }
    }

    protected class P_NewCellIdProvider
    implements IIdProvider<Activity<?, ?>> {
        protected P_NewCellIdProvider() {
        }

        @Override
        public String getId(Activity<?, ?> cell) {
            return JsonPlanner.this.createCellId(cell);
        }
    }

    protected class P_NewResourceIdProvider
    implements IIdProvider<Resource<?>> {
        protected P_NewResourceIdProvider() {
        }

        @Override
        public String getId(Resource<?> resource) {
            return JsonPlanner.this.createResourceId(resource);
        }
    }

    protected class P_PlannerListener
    extends PlannerAdapter {
        protected P_PlannerListener() {
        }

        public void plannerChanged(PlannerEvent event) {
            ModelJobs.assertModelThread();
            JsonPlanner.this.handleModelEvent(event);
        }
    }

    protected class P_ResourceIdProvider
    implements IIdProvider<Resource<?>> {
        protected P_ResourceIdProvider() {
        }

        @Override
        public String getId(Resource<?> resource) {
            return JsonPlanner.this.getResourceId(resource);
        }
    }
}

