/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.calendar;

import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.calendar.JsonRecurrencePattern;
import org.json.JSONObject;

public class JsonCalendarItem
implements IJsonObject {
    private final ICalendarItem m_item;

    public JsonCalendarItem(ICalendarItem item) {
        this.m_item = item;
    }

    public final ICalendarItem getItem() {
        return this.m_item;
    }

    public JSONObject toJson() {
        if (this.m_item == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put("exists", this.m_item.exists());
        json.put("lastModified", this.m_item.getLastModified());
        json.put("itemId", this.m_item.getItemId());
        json.put("owner", (Object)this.m_item.getOwner());
        json.put("subject", (Object)this.m_item.getSubject());
        json.put("description", (Object)this.m_item.getDescription());
        json.put("cssClass", (Object)this.m_item.getCssClass());
        json.put("recurrencePattern", (Object)new JsonRecurrencePattern(this.m_item.getRecurrencePattern()).toJson());
        return json;
    }
}

