/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.calendar;

import org.eclipse.scout.rt.shared.services.common.calendar.RecurrencePattern;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.JsonDate;
import org.json.JSONObject;

public class JsonRecurrencePattern
implements IJsonObject {
    private final RecurrencePattern m_recurrencePattern;

    public JsonRecurrencePattern(RecurrencePattern recurrencePattern) {
        this.m_recurrencePattern = recurrencePattern;
    }

    public final RecurrencePattern getRecurrencePattern() {
        return this.m_recurrencePattern;
    }

    public JSONObject toJson() {
        if (this.m_recurrencePattern == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put("lastModified", this.m_recurrencePattern.getLastModified());
        json.put("regenerate", this.m_recurrencePattern.isRegenerate());
        json.put("startTimeMinutes", this.m_recurrencePattern.getStartTimeMinutes());
        json.put("endTimeMinutes", this.m_recurrencePattern.getEndTimeMinutes());
        json.put("durationMinutes", this.m_recurrencePattern.getDurationMinutes());
        json.put("firstDate", (Object)new JsonDate(this.m_recurrencePattern.getFirstDate()).asJsonString());
        json.put("lastDate", (Object)new JsonDate(this.m_recurrencePattern.getLastDate()).asJsonString());
        json.put("occurrences", this.m_recurrencePattern.getOccurrences());
        json.put("noEndDate", this.m_recurrencePattern.getNoEndDate());
        json.put("type", this.m_recurrencePattern.getType());
        json.put("interval", this.m_recurrencePattern.getInterval());
        json.put("instance", this.m_recurrencePattern.getInstance());
        json.put("dayOfWeekBits", this.m_recurrencePattern.getDayOfWeek());
        json.put("dayOfMonth", this.m_recurrencePattern.getDayOfMonth());
        json.put("monthOfYear", this.m_recurrencePattern.getMonthOfYear());
        return json;
    }
}

