/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields;

import java.util.Date;
import java.util.List;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonDate;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.JsonStatus;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonValueField;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonDateField<T extends IDateField>
extends JsonValueField<T> {
    public JsonDateField(T model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "DateField";
    }

    @Override
    protected void initJsonProperties(T model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<T>("value", (IDateField)model){

            @Override
            protected Date modelValue() {
                return (Date)((IDateField)this.getModel()).getValue();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonDateField.this.dateToJson((Date)value);
            }
        });
        this.putJsonProperty(new JsonProperty<T>("autoDate", (IDateField)model){

            @Override
            protected Date modelValue() {
                return ((IDateField)this.getModel()).getAutoDate();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonDateField.this.dateToJson((Date)value, true, true);
            }
        });
        this.putJsonProperty(new JsonProperty<T>("hasTime", (IDateField)model){

            @Override
            protected Boolean modelValue() {
                return ((IDateField)this.getModel()).isHasTime();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("timePickerResolution", (IDateField)model){

            @Override
            protected Integer modelValue() {
                return ((IDateField)this.getModel()).getTimePickerResolution();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("hasDate", (IDateField)model){

            @Override
            protected Boolean modelValue() {
                return ((IDateField)this.getModel()).isHasDate();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("dateFormatPattern", (IDateField)model){

            @Override
            protected String modelValue() {
                return ((IDateField)this.getModel()).getDateFormatPattern();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("timeFormatPattern", (IDateField)model){

            @Override
            protected String modelValue() {
                return ((IDateField)this.getModel()).getTimeFormatPattern();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("allowedDates", (IDateField)model){

            @Override
            protected List<Date> modelValue() {
                return ((IDateField)this.getModel()).getAllowedDates();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                List allowedDates = (List)value;
                if (allowedDates == null || allowedDates.isEmpty()) {
                    return null;
                }
                JSONArray dateArray = new JSONArray();
                for (Date date : allowedDates) {
                    dateArray.put((Object)JsonDateField.this.dateToJson(date));
                }
                return dateArray;
            }
        });
    }

    protected String dateToJson(Date date) {
        return this.dateToJson(date, ((IDateField)this.getModel()).isHasDate(), ((IDateField)this.getModel()).isHasTime());
    }

    protected String dateToJson(Date date, boolean hasDate, boolean hasTime) {
        if (date == null) {
            return null;
        }
        return new JsonDate(date).asJsonString(false, hasDate, hasTime);
    }

    @Override
    protected void handleUiAcceptInput(JsonEvent event) {
        JSONObject data = event.getData();
        if (data.has("displayText")) {
            this.handleUiDisplayTextChange(data);
        }
        if (data.has("errorStatus")) {
            this.handleUiErrorStatusChange(data);
        }
        if (data.has("value")) {
            this.handleUiValueChange(data);
        }
    }

    @Override
    protected Object jsonToValue(Object jsonValue) {
        return new JsonDate((String)jsonValue).asJavaDate();
    }

    @Override
    protected void setValueFromUI(Object value) {
        ((IDateField)this.getModel()).getUIFacade().setValueFromUI((Object)((Date)value));
    }

    @Override
    protected void setDisplayTextFromUI(String displayText) {
        ((IDateField)this.getModel()).getUIFacade().setDisplayTextFromUI(displayText);
    }

    @Override
    protected void setErrorStatusFromUI(IStatus status) {
        ((IDateField)this.getModel()).getUIFacade().setErrorStatusFromUI(status);
    }

    @Override
    protected void handleUiErrorStatusChange(JSONObject data) {
        super.handleUiErrorStatusChange(data);
        JSONObject jsonStatus = data.optJSONObject("errorStatus");
        if (jsonStatus == null && ((IDateField)this.getModel()).getErrorStatus() != null) {
            this.addPropertyChangeEvent("errorStatus", (Object)JsonStatus.toJson((IStatus)((IDateField)this.getModel()).getErrorStatus()));
        }
    }
}

