/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IStatusMenuMapping;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonWidget;
import org.eclipse.scout.rt.ui.html.json.FilteredJsonAdapterIds;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonGridData;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.JsonResponse;
import org.eclipse.scout.rt.ui.html.json.MainJsonObjectFactory;
import org.eclipse.scout.rt.ui.html.json.action.DisplayableActionFilter;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfig;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfigBuilder;
import org.eclipse.scout.rt.ui.html.json.menu.IJsonContextMenuOwner;
import org.eclipse.scout.rt.ui.html.json.menu.JsonContextMenu;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonFormField<FORM_FIELD extends IFormField>
extends AbstractJsonWidget<FORM_FIELD>
implements IJsonContextMenuOwner {
    private static final Logger LOG = LoggerFactory.getLogger(JsonFormField.class);
    private PropertyChangeListener m_contextMenuListener;
    private JsonContextMenu<IContextMenu> m_jsonContextMenu;

    public JsonFormField(FORM_FIELD model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "FormField";
    }

    @Override
    protected void initJsonProperties(FORM_FIELD model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("label", (IFormField)model){

            @Override
            protected String modelValue() {
                return ((IFormField)this.getModel()).getLabel();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("labelVisible", (IFormField)model){

            @Override
            protected Boolean modelValue() {
                return ((IFormField)this.getModel()).isLabelVisible();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("labelPosition", (IFormField)model){

            @Override
            protected Integer modelValue() {
                return ((IFormField)this.getModel()).getLabelPosition();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("labelHtmlEnabled", (IFormField)model){

            @Override
            protected Boolean modelValue() {
                return ((IFormField)this.getModel()).isLabelHtmlEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("visible", (IFormField)model){

            @Override
            protected Boolean modelValue() {
                return ((IFormField)this.getModel()).isVisible();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("mandatory", (IFormField)model){

            @Override
            protected Boolean modelValue() {
                return ((IFormField)this.getModel()).isMandatory();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("tooltipText", (IFormField)model){

            @Override
            protected String modelValue() {
                return ((IFormField)this.getModel()).getTooltipText();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("tooltipAnchor", (IFormField)model){

            @Override
            protected String modelValue() {
                return ((IFormField)this.getModel()).getTooltipAnchor();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("statusVisible", (IFormField)model){

            @Override
            protected Boolean modelValue() {
                return ((IFormField)this.getModel()).isStatusVisible();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("statusPosition", (IFormField)model){

            @Override
            protected String modelValue() {
                return ((IFormField)this.getModel()).getStatusPosition();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("font", (IFormField)model){

            @Override
            protected Object modelValue() {
                return ((IFormField)this.getModel()).getFont();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return value instanceof FontSpec ? ((FontSpec)value).toPattern() : null;
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("backgroundColor", (IFormField)model){

            @Override
            protected String modelValue() {
                return ((IFormField)this.getModel()).getBackgroundColor();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("foregroundColor", (IFormField)model){

            @Override
            protected String modelValue() {
                return ((IFormField)this.getModel()).getForegroundColor();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("labelFont", (IFormField)model){

            @Override
            protected Object modelValue() {
                return ((IFormField)this.getModel()).getLabelFont();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return value instanceof FontSpec ? ((FontSpec)value).toPattern() : null;
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("labelBackgroundColor", (IFormField)model){

            @Override
            protected String modelValue() {
                return ((IFormField)this.getModel()).getLabelBackgroundColor();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("labelForegroundColor", (IFormField)model){

            @Override
            protected String modelValue() {
                return ((IFormField)this.getModel()).getLabelForegroundColor();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("labelForegroundColor", (IFormField)model){

            @Override
            protected String modelValue() {
                return ((IFormField)this.getModel()).getLabelForegroundColor();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("labelWidthInPixel", (IFormField)model){

            @Override
            protected Integer modelValue() {
                return ((IFormField)this.getModel()).getLabelWidthInPixel();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("labelUseUiWidth", (IFormField)model){

            @Override
            protected Boolean modelValue() {
                return ((IFormField)this.getModel()).isLabelUseUiWidth();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("errorStatus", (IFormField)model){

            protected IStatus modelValue() {
                return ((IFormField)this.getModel()).getErrorStatus();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return MainJsonObjectFactory.get().createJsonObject(value).toJson();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("gridData", (IFormField)model){

            protected GridData modelValue() {
                return ((IFormField)this.getModel()).getGridData();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonGridData.toJson((GridData)value);
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("loading", (IFormField)model){

            @Override
            protected Boolean modelValue() {
                return ((IFormField)this.getModel()).isLoading();
            }
        });
        this.putJsonProperty(new JsonAdapterProperty<FORM_FIELD>("keyStrokes", (IFormField)model, this.getUiSession()){

            @Override
            protected JsonAdapterPropertyConfig createConfig() {
                return new JsonAdapterPropertyConfigBuilder().filter(new DisplayableActionFilter()).build();
            }

            @Override
            protected List<IKeyStroke> modelValue() {
                return ((IFormField)this.getModel()).getKeyStrokes();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("preventInitialFocus", (IFormField)model){

            @Override
            protected Boolean modelValue() {
                return ((IFormField)this.getModel()).isPreventInitialFocus();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("fieldStyle", (IFormField)model){

            @Override
            protected String modelValue() {
                return ((IFormField)this.getModel()).getFieldStyle();
            }
        });
        this.putJsonProperty(new JsonProperty<FORM_FIELD>("disabledStyle", (IFormField)model){

            @Override
            protected Integer modelValue() {
                return ((IFormField)this.getModel()).getDisabledStyle();
            }
        });
        this.putJsonProperty(new JsonAdapterProperty<FORM_FIELD>("statusMenuMappings", (IFormField)model, this.getUiSession()){

            @Override
            protected List<IStatusMenuMapping> modelValue() {
                return ((IFormField)this.getModel()).getStatusMenuMappings();
            }
        });
    }

    @Override
    protected void attachChildAdapters() {
        super.attachChildAdapters();
        this.m_jsonContextMenu = new JsonContextMenu<IContextMenu>(((IFormField)this.getModel()).getContextMenu(), this);
        this.m_jsonContextMenu.init();
    }

    @Override
    protected void disposeChildAdapters() {
        this.m_jsonContextMenu.dispose();
        super.disposeChildAdapters();
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        if (this.m_contextMenuListener != null) {
            throw new IllegalStateException();
        }
        this.m_contextMenuListener = evt -> {
            if ("visible".equals(evt.getPropertyName())) {
                this.handleModelContextMenuVisibleChanged((Boolean)evt.getNewValue());
            } else if ("currentMenuTypes".equals(evt.getPropertyName())) {
                Set newValue = (Set)evt.getNewValue();
                this.handleModelContextMenuCurrentMenuTypesChanged(newValue);
            }
        };
        ((IFormField)this.getModel()).getContextMenu().addPropertyChangeListener(this.m_contextMenuListener);
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        if (this.m_contextMenuListener == null) {
            throw new IllegalStateException();
        }
        ((IFormField)this.getModel()).getContextMenu().removePropertyChangeListener(this.m_contextMenuListener);
        this.m_contextMenuListener = null;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        json.put("menus", (Object)this.m_jsonContextMenu.childActionsToJson());
        json.put("menusVisible", ((IFormField)this.getModel()).getContextMenu().isVisible());
        json.put("currentMenuTypes", (Object)this.menuTypesToJson(((IFormField)this.getModel()).getContextMenu().getCurrentMenuTypes()));
        return json;
    }

    protected JSONArray menuTypesToJson(Set<? extends IMenuType> menuTypes) {
        JSONArray array = new JSONArray();
        if (menuTypes == null) {
            return array;
        }
        for (IMenuType iMenuType : menuTypes) {
            String prefix = iMenuType.getClass().getSimpleName().replace("MenuType", "");
            array.put((Object)(String.valueOf(prefix) + "." + iMenuType));
        }
        return array;
    }

    @Override
    protected void handleModelPropertyChange(PropertyChangeEvent event) {
        if ("visible".equals(event.getPropertyName()) && !((IFormField)this.getModel()).isVisibleGranted()) {
            JsonResponse response = this.getUiSession().currentJsonResponse();
            if (response.containsAdapter(this) && response.isWritable()) {
                this.dispose();
                return;
            }
            LOG.warn("Setting visibleGranted=false has no effect, because JsonAdapter {} ({}) is already sent to the UI.", (Object)this.getId(), this.getModel());
        }
        super.handleModelPropertyChange(event);
    }

    @Override
    public void handleModelContextMenuChanged(FilteredJsonAdapterIds<?> filteredAdapters) {
        this.addPropertyChangeEvent("menus", filteredAdapters);
    }

    protected void handleModelContextMenuVisibleChanged(boolean visible) {
        this.addPropertyChangeEvent("menusVisible", (Object)visible);
    }

    protected void handleModelContextMenuCurrentMenuTypesChanged(Set<? extends IMenuType> currentMenuTypes) {
        this.addPropertyChangeEvent("currentMenuTypes", (Object)this.menuTypesToJson(currentMenuTypes));
    }
}

