/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields;

import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.ParsingFailedStatus;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.JsonStatus;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonFormField;
import org.json.JSONObject;

public abstract class JsonValueField<VALUE_FIELD extends IValueField<?>>
extends JsonFormField<VALUE_FIELD> {
    public static final String EVENT_ACCEPT_INPUT = "acceptInput";

    public JsonValueField(VALUE_FIELD model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "ValueField";
    }

    @Override
    protected void initJsonProperties(VALUE_FIELD model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<VALUE_FIELD>("displayText", (IValueField)model){

            @Override
            protected String modelValue() {
                return ((IValueField)this.getModel()).getDisplayText();
            }
        });
        this.putJsonProperty(new JsonProperty<VALUE_FIELD>("clearable", (IValueField)model){

            @Override
            protected Object modelValue() {
                return ((IValueField)this.getModel()).getClearable();
            }
        });
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_ACCEPT_INPUT.equals(event.getType())) {
            this.handleUiAcceptInput(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiAcceptInput(JsonEvent event) {
        String displayText = event.getData().optString("displayText");
        this.addPropertyEventFilterCondition("displayText", displayText);
        boolean whileTyping = event.getData().optBoolean("whileTyping", false);
        if (whileTyping) {
            this.handleUiAcceptInputWhileTyping(displayText);
        } else {
            this.handleUiAcceptInputAfterTyping(displayText);
        }
    }

    protected void handleUiDisplayTextChange(JSONObject data) {
        String displayText = data.optString("displayText");
        this.addPropertyEventFilterCondition("displayText", displayText);
        this.setDisplayTextFromUI(displayText);
    }

    protected void setDisplayTextFromUI(String displayText) {
    }

    protected void handleUiValueChange(JSONObject data) {
        Object jsonValue = data.isNull("value") ? null : data.get("value");
        Object value = this.jsonToValue(jsonValue);
        this.addPropertyEventFilterCondition("value", value);
        this.setValueFromUI(value);
    }

    protected void setValueFromUI(Object value) {
    }

    protected Object jsonToValue(Object jsonValue) {
        return jsonValue;
    }

    protected void handleUiErrorStatusChange(JSONObject data) {
        JSONObject jsonStatus = data.optJSONObject("errorStatus");
        this.addPropertyEventFilterCondition("errorStatus", jsonStatus);
        ParsingFailedStatus status = null;
        if (jsonStatus != null) {
            status = new ParsingFailedStatus(JsonStatus.toScoutObject(jsonStatus), ((IValueField)this.getModel()).getDisplayText());
        }
        this.setErrorStatusFromUI((IStatus)status);
    }

    protected void setErrorStatusFromUI(IStatus status) {
    }

    protected void handleUiAcceptInputWhileTyping(String displayText) {
    }

    protected void handleUiAcceptInputAfterTyping(String displayText) {
    }
}

