/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.browserfield;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.server.commons.servlet.ContentSecurityPolicy;
import org.eclipse.scout.rt.server.commons.servlet.HttpClientInfo;
import org.eclipse.scout.rt.server.commons.servlet.cache.IHttpResponseInterceptor;
import org.eclipse.scout.rt.ui.html.IUiSession;

public class BrowserFieldContentHttpResponseInterceptor
implements IHttpResponseInterceptor {
    private static final long serialVersionUID = 1L;
    private final URI m_browserUri;

    public BrowserFieldContentHttpResponseInterceptor(IUiSession uiSession) {
        this.m_browserUri = uiSession.getClientSession().getBrowserURI();
    }

    public void intercept(HttpServletRequest req, HttpServletResponse resp) {
        ContentSecurityPolicy csp = ((ContentSecurityPolicy)BEANS.get(ContentSecurityPolicy.class)).appendScriptSrc("'unsafe-inline'");
        HttpClientInfo httpClientInfo = HttpClientInfo.get((HttpServletRequest)req);
        if (httpClientInfo.isWebkit()) {
            String resolvedSelfUri = this.m_browserUri.toString();
            csp.appendImgSrc(resolvedSelfUri).appendStyleSrc(resolvedSelfUri);
        }
        String cspToken = csp.toToken();
        if (httpClientInfo.isMshtml()) {
            resp.setHeader("X-Content-Security-Policy", cspToken);
        } else {
            resp.setHeader("Content-Security-Policy", cspToken);
        }
    }
}

