/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.clipboardfield;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.form.fields.clipboardfield.IClipboardField;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.resource.BinaryResources;
import org.eclipse.scout.rt.platform.resource.MimeType;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonValueField;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceConsumer;
import org.json.JSONArray;

public class JsonClipboardField<T extends IClipboardField>
extends JsonValueField<T>
implements IBinaryResourceConsumer {
    public JsonClipboardField(T model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "ClipboardField";
    }

    @Override
    protected void initJsonProperties(T model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<IClipboardField>("allowedMimeTypes", model){

            @Override
            protected List<String> modelValue() {
                return ((IClipboardField)this.getModel()).getAllowedMimeTypes();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return new JSONArray((Collection)value);
            }
        });
        this.putJsonProperty(new JsonProperty<IClipboardField>("maximumSize", model){

            @Override
            protected Long modelValue() {
                return ((IClipboardField)this.getModel()).getMaximumSize();
            }
        });
        this.putJsonProperty(new JsonProperty<IClipboardField>("dropType", model){

            @Override
            protected Integer modelValue() {
                return ((IClipboardField)this.getModel()).getDropType();
            }
        });
        this.putJsonProperty(new JsonProperty<IClipboardField>("readOnly", model){

            @Override
            protected Boolean modelValue() {
                return ((IClipboardField)this.getModel()).isReadOnly();
            }
        });
    }

    @Override
    public void consumeBinaryResource(List<BinaryResource> binaryResources, Map<String, String> uploadProperties) {
        binaryResources = new ArrayList<BinaryResource>(binaryResources);
        for (Map.Entry<String, String> property : uploadProperties.entrySet()) {
            if (!property.getKey().matches("textTransferObject\\d+")) continue;
            byte[] bytes = property.getValue().getBytes(StandardCharsets.UTF_8);
            binaryResources.add(BinaryResources.create().withContentType(MimeType.TXT.getType()).withContent(bytes).build());
        }
        ((IClipboardField)this.getModel()).setValue(binaryResources);
    }

    @Override
    public long getMaximumUploadSize() {
        return ((IClipboardField)this.getModel()).getMaximumSize();
    }
}

