/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.htmlfield;

import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlField;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonEventType;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonValueField;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceHolder;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceProvider;

public class JsonHtmlField<HTML_FIELD extends IHtmlField>
extends JsonValueField<HTML_FIELD>
implements IBinaryResourceProvider {
    public JsonHtmlField(HTML_FIELD model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "HtmlField";
    }

    @Override
    protected void initJsonProperties(HTML_FIELD model) {
        super.initJsonProperties(model);
        this.removeJsonProperty("value");
        this.putJsonProperty(new JsonProperty<IHtmlField>("displayText", model){

            @Override
            protected String modelValue() {
                return ((IHtmlField)this.getModel()).getDisplayText();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return BinaryResourceUrlUtility.replaceImageUrls(JsonHtmlField.this, (String)value);
            }
        });
        this.putJsonProperty(new JsonProperty<IHtmlField>("selectable", model){

            @Override
            protected Boolean modelValue() {
                return ((IHtmlField)this.getModel()).isSelectable();
            }
        });
        this.putJsonProperty(new JsonProperty<IHtmlField>("scrollBarEnabled", model){

            @Override
            protected Boolean modelValue() {
                return ((IHtmlField)this.getModel()).isScrollBarEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<IHtmlField>("scrollToEnd", model){

            @Override
            protected Object modelValue() {
                return null;
            }
        });
        this.putJsonProperty(new JsonProperty<IHtmlField>("scrollToAnchor", model){

            @Override
            protected String modelValue() {
                return ((IHtmlField)this.getModel()).getScrollToAnchor();
            }
        });
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (JsonEventType.APP_LINK_ACTION.matches(event.getType())) {
            this.handleUiAppLinkAction(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiAppLinkAction(JsonEvent event) {
        String ref = event.getData().optString("ref", null);
        ((IHtmlField)this.getModel()).getUIFacade().fireAppLinkActionFromUI(ref);
    }

    @Override
    public BinaryResourceHolder provideBinaryResource(String filename) {
        BinaryResource attachment = ((IHtmlField)this.getModel()).getAttachment(filename);
        return attachment == null ? null : new BinaryResourceHolder(attachment);
    }
}

