/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.imagefield;

import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.dnd.ResourceListTransferObject;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.form.fields.imagefield.IImageField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.basic.filechooser.JsonFileChooserAcceptAttributeBuilder;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonFormField;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceHolder;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceConsumer;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceProvider;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonImageField<IMAGE_FIELD extends IImageField>
extends JsonFormField<IMAGE_FIELD>
implements IBinaryResourceProvider,
IBinaryResourceConsumer {
    public static final String PROP_IMAGE_URL = "imageUrl";
    public static final String PROP_ACCEPT_TYPES = "acceptTypes";

    public JsonImageField(IMAGE_FIELD model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "ImageField";
    }

    @Override
    protected void initJsonProperties(IMAGE_FIELD model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<IMAGE_FIELD>("scrollBarEnabled", (IImageField)model){

            @Override
            protected Boolean modelValue() {
                return ((IImageField)this.getModel()).isScrollBarEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<IMAGE_FIELD>("autoFit", (IImageField)model){

            @Override
            protected Boolean modelValue() {
                return ((IImageField)this.getModel()).isAutoFit();
            }
        });
        this.putJsonProperty(new JsonProperty<IMAGE_FIELD>("dropType", (IImageField)model){

            @Override
            protected Integer modelValue() {
                return ((IImageField)this.getModel()).getDropType();
            }
        });
        this.putJsonProperty(new JsonProperty<IMAGE_FIELD>("dropMaximumSize", (IImageField)model){

            @Override
            protected Long modelValue() {
                return ((IImageField)this.getModel()).getDropMaximumSize();
            }
        });
        this.putJsonProperty(new JsonProperty<IMAGE_FIELD>("uploadEnabled", (IImageField)model){

            @Override
            protected Boolean modelValue() {
                return ((IImageField)this.getModel()).isUploadEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<IMAGE_FIELD>("fileExtensions", (IImageField)model){

            @Override
            protected List<String> modelValue() {
                return ((IImageField)this.getModel()).getFileExtensions();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                List fileExtensions = (List)value;
                return new JSONArray(((JsonFileChooserAcceptAttributeBuilder)BEANS.get(JsonFileChooserAcceptAttributeBuilder.class)).withTypes(fileExtensions).build());
            }

            @Override
            public String jsonPropertyName() {
                return JsonImageField.PROP_ACCEPT_TYPES;
            }
        });
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        json.put(PROP_IMAGE_URL, (Object)this.getImageUrl());
        return json;
    }

    @Override
    protected void handleModelPropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (ObjectUtility.isOneOf((Object)propertyName, (Object)"image", (Object[])new Object[]{"imageId", PROP_IMAGE_URL})) {
            this.handleModelImageSourceChanged();
        } else {
            super.handleModelPropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void handleModelImageSourceChanged() {
        this.addPropertyChangeEvent(PROP_IMAGE_URL, (Object)this.getImageUrl());
    }

    protected String getImageUrl() {
        BinaryResource imageResource;
        if (((IImageField)this.getModel()).getImage() != null && (imageResource = BinaryResourceUrlUtility.extractBinaryResource(((IImageField)this.getModel()).getImage(), "image", "jpg")) != null && imageResource.getContent() != null) {
            return BinaryResourceUrlUtility.createDynamicAdapterResourceUrl(this, imageResource);
        }
        if (((IImageField)this.getModel()).getImageUrl() != null) {
            return ((IImageField)this.getModel()).getImageUrl();
        }
        String imageId = ((IImageField)this.getModel()).getImageId();
        if (imageId != null) {
            if (this.isFontIcon(imageId)) {
                return imageId;
            }
            return BinaryResourceUrlUtility.createIconUrl(imageId);
        }
        return null;
    }

    protected boolean isFontIcon(String imageId) {
        if (StringUtility.isNullOrEmpty((CharSequence)imageId)) {
            return false;
        }
        return imageId.startsWith("font:");
    }

    @Override
    public BinaryResourceHolder provideBinaryResource(String requestFilename) {
        BinaryResource image = BinaryResourceUrlUtility.extractBinaryResource(((IImageField)this.getModel()).getImage(), "image", "jpg");
        if (image == null || image.getContent() == null) {
            return null;
        }
        String imageFilenameWithFingerprint = BinaryResourceUrlUtility.getFilenameWithFingerprint(image);
        if (imageFilenameWithFingerprint.equals(requestFilename)) {
            return new BinaryResourceHolder(image);
        }
        return null;
    }

    @Override
    public void consumeBinaryResource(List<BinaryResource> binaryResources, Map<String, String> uploadProperties) {
        if ((((IImageField)this.getModel()).getDropType() & 1) == 1) {
            ResourceListTransferObject transferObject = new ResourceListTransferObject(binaryResources);
            ((IImageField)this.getModel()).getUIFacade().fireDropActionFromUi((TransferObject)transferObject);
        }
    }

    @Override
    public long getMaximumUploadSize() {
        return ((IImageField)this.getModel()).getDropMaximumSize();
    }
}

