/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.numberfield;

import java.text.DecimalFormat;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.INumberField;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.MainJsonObjectFactory;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonBasicField;

public class JsonNumberField<T extends INumberField<? extends Number>>
extends JsonBasicField<T> {
    public JsonNumberField(T model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "NumberField";
    }

    @Override
    protected void handleUiAcceptInputWhileTyping(String displayText) {
        ((INumberField)this.getModel()).getUIFacade().setDisplayTextFromUI(displayText);
    }

    @Override
    protected void handleUiAcceptInputAfterTyping(String displayText) {
        ((INumberField)this.getModel()).getUIFacade().parseAndSetValueFromUI(displayText);
    }

    @Override
    protected void initJsonProperties(T model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<INumberField<?>>("decimalFormat", (INumberField)model){

            @Override
            protected Object modelValue() {
                return ((INumberField)this.getModel()).getFormat();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                DecimalFormat format = (DecimalFormat)value;
                return MainJsonObjectFactory.get().createJsonObject(format).toJson();
            }
        });
    }
}

