/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.smartfield;

import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IProposalField;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.smartfield.JsonSmartField;
import org.json.JSONObject;

public class JsonProposalField<VALUE, MODEL extends IProposalField<VALUE>>
extends JsonSmartField<VALUE, MODEL> {
    public JsonProposalField(MODEL model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "ProposalField";
    }

    @Override
    protected void initJsonProperties(MODEL model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<IProposalField<VALUE>>("trimText", (IProposalField)model){

            @Override
            protected Boolean modelValue() {
                return ((IProposalField)this.getModel()).isTrimText();
            }
        });
    }

    @Override
    protected Object jsonToValue(Object jsonValue) {
        return jsonValue;
    }

    @Override
    protected Object valueToJson(VALUE value) {
        if (value == null) {
            return null;
        }
        Assertions.assertInstance(value, String.class);
        return value;
    }

    @Override
    protected void setValueFromUI(Object value) {
        ((IProposalField)this.getModel()).getUIFacade().setValueAsStringFromUI((String)value);
    }

    @Override
    protected void handleUiAcceptInput(JsonEvent event) {
        JSONObject data = event.getData();
        if (data.has("displayText")) {
            this.handleUiDisplayTextChange(data);
        }
        if (data.has("errorStatus")) {
            this.handleUiErrorStatusChange(data);
        }
        if (data.has("lookupRow")) {
            this.handleUiLookupRowChange(data);
        }
        if (data.has("value")) {
            this.handleUiValueChange(data);
        }
    }
}

