/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.smartfield;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallResult;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ColumnDescriptor;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.util.NumberUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TriState;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.JsonStatus;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonValueField;
import org.eclipse.scout.rt.ui.html.json.lookup.JsonLookupCallResult;
import org.eclipse.scout.rt.ui.html.json.lookup.JsonLookupRow;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonSmartField<VALUE, MODEL extends ISmartField<VALUE>>
extends JsonValueField<MODEL> {
    private final Map<Object, Integer> m_keyToIdMap = new HashMap<Object, Integer>();
    private final Map<Integer, Object> m_idToKeyMap = new HashMap<Integer, Object>();
    private int m_id = 0;

    public JsonSmartField(MODEL model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    protected void initJsonProperties(MODEL model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<ISmartField<VALUE>>("value", (ISmartField)model){

            @Override
            protected VALUE modelValue() {
                return ((ISmartField)this.getModel()).getValue();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonSmartField.this.valueToJson(value);
            }
        });
        this.putJsonProperty(new JsonProperty<ISmartField<VALUE>>("result", (ISmartField)model){

            @Override
            public boolean accept() {
                return ((ISmartField)this.getModel()).getResult() != null;
            }

            @Override
            protected Object modelValue() {
                return ((ISmartField)this.getModel()).getResult();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonSmartField.this.resultToJson((ILookupCallResult)value);
            }
        });
        this.putJsonProperty(new JsonProperty<ISmartField<VALUE>>("lookupRow", (ISmartField)model){

            @Override
            protected Object modelValue() {
                return ((ISmartField)this.getModel()).getLookupRow();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonSmartField.this.lookupRowToJson((ILookupRow<?>)((LookupRow)value), JsonSmartField.this.hasMultipleColumns());
            }
        });
        this.putJsonProperty(new JsonProperty<ISmartField<VALUE>>("browseMaxRowCount", (ISmartField)model){

            @Override
            protected Integer modelValue() {
                return ((ISmartField)this.getModel()).getBrowseMaxRowCount();
            }
        });
        this.putJsonProperty(new JsonProperty<ISmartField<VALUE>>("browseAutoExpandAll", (ISmartField)model){

            @Override
            protected Boolean modelValue() {
                return ((ISmartField)this.getModel()).isBrowseAutoExpandAll();
            }
        });
        this.putJsonProperty(new JsonProperty<ISmartField<VALUE>>("browseLoadIncremental", (ISmartField)model){

            @Override
            protected Boolean modelValue() {
                return ((ISmartField)this.getModel()).isBrowseLoadIncremental();
            }
        });
        this.putJsonProperty(new JsonProperty<ISmartField<VALUE>>("browseHierarchy", (ISmartField)model){

            @Override
            protected Boolean modelValue() {
                return ((ISmartField)this.getModel()).isBrowseHierarchy();
            }
        });
        this.putJsonProperty(new JsonProperty<ISmartField<VALUE>>("activeFilterEnabled", (ISmartField)model){

            @Override
            protected Boolean modelValue() {
                return ((ISmartField)this.getModel()).isActiveFilterEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<ISmartField<VALUE>>("searchRequired", (ISmartField)model){

            @Override
            protected Boolean modelValue() {
                return ((ISmartField)this.getModel()).isSearchRequired();
            }
        });
        this.putJsonProperty(new JsonProperty<ISmartField<VALUE>>("activeFilter", (ISmartField)model){

            protected TriState modelValue() {
                return ((ISmartField)this.getModel()).getActiveFilter();
            }
        });
        this.putJsonProperty(new JsonProperty<ISmartField<VALUE>>("activeFilterLabels", (ISmartField)model){

            protected String[] modelValue() {
                return ((ISmartField)this.getModel()).getActiveFilterLabels();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return new JSONArray(value);
            }
        });
        this.putJsonProperty(new JsonProperty<ISmartField<VALUE>>("columnDescriptors", (ISmartField)model){

            protected ColumnDescriptor[] modelValue() {
                return ((ISmartField)this.getModel()).getColumnDescriptors();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonSmartField.this.columnDescriptorsToJson((ColumnDescriptor[])value);
            }
        });
        this.putJsonProperty(new JsonProperty<ISmartField<VALUE>>("maxLength", (ISmartField)model){

            @Override
            protected Integer modelValue() {
                return ((ISmartField)this.getModel()).getMaxLength();
            }
        });
    }

    @Override
    public String getObjectType() {
        if (((ISmartField)this.getModel()).isMultilineText()) {
            return "SmartFieldMultiline";
        }
        return "SmartField";
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if ("lookupByAll".equals(event.getType())) {
            this.handleUiLookupByAll();
        } else if ("lookupByText".equals(event.getType())) {
            this.handleUiLookupByText(event);
        } else if ("lookupByKey".equals(event.getType())) {
            this.handleUiLookupByKey(event);
        } else if ("lookupByRec".equals(event.getType())) {
            this.handleUiLookupByRec(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    @Override
    protected void handleUiAcceptInput(JsonEvent event) {
        Object valueFromModel;
        JSONObject data = event.getData();
        boolean valueSet = false;
        Object valueFromUi = null;
        if (data.has("displayText")) {
            this.handleUiDisplayTextChange(data);
        }
        if (data.has("lookupRow")) {
            valueFromUi = this.valueFromJsonLookupRow(data);
            this.handleUiLookupRowChange(data);
            valueSet = true;
        } else if (data.has("value")) {
            valueFromUi = this.valueFromJsonValue(data);
            this.handleUiValueChange(data);
            valueSet = true;
        }
        this.addPropertyChangeEvent("errorStatus", (Object)JsonStatus.toJson((IStatus)((ISmartField)this.getModel()).getErrorStatus()));
        if (valueSet && !ObjectUtility.equals(valueFromUi, (Object)(valueFromModel = ((ISmartField)this.getModel()).getValue()))) {
            this.addPropertyChangeEvent("lookupRow", this.lookupRowToJson(((ISmartField)this.getModel()).getLookupRow(), this.hasMultipleColumns()));
            String displayTextFromModel = ((ISmartField)this.getModel()).getDisplayText();
            this.addPropertyChangeEvent("displayText", (Object)displayTextFromModel);
            return;
        }
        if (valueSet) {
            return;
        }
        if (data.has("errorStatus")) {
            this.handleUiErrorStatusChange(data);
        }
    }

    protected VALUE valueFromJsonValue(JSONObject data) {
        return (VALUE)this.jsonToValue(data.optString("value", null));
    }

    protected VALUE valueFromJsonLookupRow(JSONObject data) {
        JSONObject jsonLookupRow = data.optJSONObject("lookupRow");
        ILookupRow<VALUE> lookupRow = this.lookupRowFromJson(jsonLookupRow);
        return (VALUE)(lookupRow == null ? null : lookupRow.getKey());
    }

    @Override
    protected void handleUiPropertyChange(String propertyName, JSONObject data) {
        if ("value".equals(propertyName)) {
            this.handleUiValueChange(data);
        } else if ("displayText".equals(propertyName)) {
            this.handleUiDisplayTextChange(data);
        } else if ("lookupRow".equals(propertyName)) {
            this.handleUiLookupRowChange(data);
        } else if ("activeFilter".equals(propertyName)) {
            String activeFilterString = data.optString(propertyName, null);
            TriState activeFilter = TriState.valueOf((String)activeFilterString);
            this.addPropertyEventFilterCondition(propertyName, activeFilter);
            ((ISmartField)this.getModel()).getUIFacade().setActiveFilterFromUI(activeFilter);
        } else if ("errorStatus".equals(propertyName)) {
            this.handleUiErrorStatusChange(data);
        } else {
            super.handleUiPropertyChange(propertyName, data);
        }
    }

    @Override
    protected Object jsonToValue(Object jsonValue) {
        return this.getLookupRowKeyForId((String)jsonValue);
    }

    protected Object valueToJson(VALUE value) {
        if (value == null) {
            return null;
        }
        return this.getIdForLookupRowKey(value);
    }

    @Override
    protected void setValueFromUI(Object value) {
        ((ISmartField)this.getModel()).getUIFacade().setValueFromUI(value);
    }

    @Override
    protected void setDisplayTextFromUI(String displayText) {
        ((ISmartField)this.getModel()).getUIFacade().setDisplayTextFromUI(displayText);
    }

    @Override
    protected void setErrorStatusFromUI(IStatus status) {
        ((ISmartField)this.getModel()).getUIFacade().setErrorStatusFromUI(status);
    }

    protected void handleUiLookupRowChange(JSONObject data) {
        JSONObject jsonLookupRow = data.optJSONObject("lookupRow");
        ILookupRow<VALUE> lookupRow = this.lookupRowFromJson(jsonLookupRow);
        Object value = lookupRow == null ? null : lookupRow.getKey();
        this.addPropertyEventFilterCondition("lookupRow", lookupRow);
        this.addPropertyEventFilterCondition("value", value);
        ((ISmartField)this.getModel()).getUIFacade().setLookupRowFromUI(lookupRow);
    }

    protected void handleUiLookupByText(JsonEvent event) {
        String text = event.getData().optString("text");
        ((ISmartField)this.getModel()).lookupByText(text);
    }

    protected void handleUiLookupByRec(JsonEvent event) {
        String mappedParentKey = event.getData().optString("rec", null);
        VALUE rec = this.getLookupRowKeyForId(mappedParentKey);
        ((ISmartField)this.getModel()).lookupByRec(rec);
    }

    protected void handleUiLookupByKey(JsonEvent event) {
        String mappedKey = event.getData().optString("key", null);
        VALUE key = this.getLookupRowKeyForId(mappedKey);
        ((ISmartField)this.getModel()).lookupByKey(key);
    }

    protected void handleUiLookupByAll() {
        ((ISmartField)this.getModel()).lookupByAll();
    }

    protected void resetKeyMap() {
        this.m_keyToIdMap.clear();
        this.m_idToKeyMap.clear();
        this.m_id = 0;
    }

    protected int getIdForLookupRowKey(Object key) {
        if (this.m_keyToIdMap.containsKey(key)) {
            return this.m_keyToIdMap.get(key);
        }
        int id = this.m_id++;
        this.m_keyToIdMap.put(key, id);
        this.m_idToKeyMap.put(id, key);
        return id;
    }

    protected boolean hasMultipleColumns() {
        return ((ISmartField)this.getModel()).getColumnDescriptors() != null;
    }

    protected Object resultToJson(ILookupCallResult<VALUE> result) {
        return new P_JsonLookupCallResult(result, this.hasMultipleColumns(), this::getIdForLookupRowKey).toJson();
    }

    protected ILookupRow<VALUE> lookupRowFromJson(JSONObject json) {
        if (json == null) {
            return null;
        }
        VALUE lookupRowKey = this.getLookupRowKeyForId(json.optString("key", null));
        String lookupRowText = json.optString("text");
        return this.createLookupRow(lookupRowKey, lookupRowText, json);
    }

    protected ILookupRow<VALUE> createLookupRow(VALUE key, String text, JSONObject json) {
        return this.applyJson(new LookupRow(key, text), json);
    }

    protected <LOOKUP_ROW extends ILookupRow<VALUE>> LOOKUP_ROW applyJson(LOOKUP_ROW lookupRow, JSONObject json) {
        if (json.has("iconId")) {
            lookupRow.withIconId(json.optString("iconId", null));
        }
        if (json.has("enabled")) {
            lookupRow.withEnabled(json.getBoolean("enabled"));
        }
        if (json.has("tooltipText")) {
            lookupRow.withTooltipText(json.optString("tooltipText", null));
        }
        if (json.has("backgroundColor")) {
            lookupRow.withBackgroundColor(json.optString("backgroundColor", null));
        }
        if (json.has("foregroundColor")) {
            lookupRow.withForegroundColor(json.optString("foregroundColor", null));
        }
        if (json.has("font")) {
            lookupRow.withFont(FontSpec.parse((String)json.optString("font", null)));
        }
        if (json.has("parentKey")) {
            lookupRow.withParentKey(this.getLookupRowKeyForId(json.optString("parentKey", null)));
        }
        if (json.has("active")) {
            lookupRow.withActive(json.getBoolean("active"));
        }
        if (json.has("cssClass")) {
            lookupRow.withCssClass(json.optString("cssClass", null));
        }
        return lookupRow;
    }

    protected Object lookupRowToJson(ILookupRow<?> lookupRow, boolean multipleColumns) {
        return JsonLookupRow.toJson(lookupRow, multipleColumns, this::getIdForLookupRowKey);
    }

    protected VALUE getLookupRowKeyForId(String id) {
        if (StringUtility.isNullOrEmpty((CharSequence)id)) {
            return null;
        }
        return (VALUE)this.m_idToKeyMap.get(NumberUtility.parseInt((String)id));
    }

    protected JSONArray columnDescriptorsToJson(ColumnDescriptor[] descriptors) {
        if (descriptors == null) {
            return null;
        }
        JSONArray array = new JSONArray();
        ColumnDescriptor[] columnDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDescriptor desc = columnDescriptorArray[n2];
            JSONObject json = this.columnDescriptorToJson(desc);
            if (json != null) {
                array.put((Object)json);
            }
            ++n2;
        }
        return array;
    }

    protected JSONObject columnDescriptorToJson(ColumnDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put("propertyName", (Object)descriptor.getPropertyName());
        json.put("text", (Object)descriptor.getText());
        json.put("cssClass", (Object)descriptor.getCssClass());
        json.put("width", descriptor.getWidth());
        json.put("fixedWidth", descriptor.isFixedWidth());
        json.put("horizontalAlignment", descriptor.getHorizontalAlignment());
        json.put("visible", descriptor.isVisible());
        json.put("htmlEnabled", descriptor.isHtmlEnabled());
        return json;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        json.put("displayStyle", (Object)((ISmartField)this.getModel()).getDisplayStyle());
        return json;
    }

    class P_JsonLookupCallResult
    extends JsonLookupCallResult<VALUE> {
        public P_JsonLookupCallResult(ILookupCallResult<VALUE> result, boolean multipleColumns, Function<VALUE, ?> keyMapper) {
            super(result, multipleColumns, keyMapper);
        }

        @Override
        protected Object lookupRowToJson(ILookupRow<VALUE> lookupRow, boolean multipleColumns) {
            return JsonSmartField.this.lookupRowToJson(lookupRow, multipleColumns);
        }
    }
}

