/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.splitbox;

import java.util.List;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.ISplitBox;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonObjectUtility;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonFormField;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSplitBox<SPLIT_BOX extends ISplitBox>
extends JsonFormField<SPLIT_BOX> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonSplitBox.class);
    public static final String EVENT_SET_SPLITTER_POSITION = "setSplitterPosition";
    private final IFormField m_firstField;
    private final IFormField m_secondField;

    public JsonSplitBox(SPLIT_BOX model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
        List fields = model.getFields();
        int numFields = fields.size();
        IFormField firstField = null;
        IFormField secondField = null;
        if (numFields >= 1) {
            firstField = (IFormField)fields.get(0);
        }
        if (numFields >= 2) {
            secondField = (IFormField)fields.get(1);
        }
        if (numFields > 2) {
            LOG.warn("Split box only supports two fields. {} surplus fields are ignored in {}.", (Object)(numFields - 2), model);
        }
        this.m_firstField = JsonSplitBox.getFieldIfVisibleGranted(firstField);
        this.m_secondField = JsonSplitBox.getFieldIfVisibleGranted(secondField);
    }

    @Override
    public String getObjectType() {
        return "SplitBox";
    }

    protected static IFormField getFieldIfVisibleGranted(IFormField field) {
        return field != null && field.isVisibleGranted() ? field : null;
    }

    @Override
    protected void initJsonProperties(SPLIT_BOX model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<ISplitBox>("splitterPosition", model){

            @Override
            protected Double modelValue() {
                return ((ISplitBox)this.getModel()).getSplitterPosition();
            }
        });
        this.putJsonProperty(new JsonProperty<ISplitBox>("minSplitterPosition", model){

            @Override
            protected Double modelValue() {
                return ((ISplitBox)this.getModel()).getMinSplitterPosition();
            }
        });
        this.putJsonProperty(new JsonProperty<ISplitBox>("splitterPositionType", model){

            @Override
            protected String modelValue() {
                return ((ISplitBox)this.getModel()).getSplitterPositionType();
            }
        });
        this.putJsonProperty(new JsonProperty<ISplitBox>("splitterEnabled", model){

            @Override
            protected Boolean modelValue() {
                return ((ISplitBox)this.getModel()).isSplitterEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<ISplitBox>("collapsibleField", model){

            protected IFormField modelValue() {
                return ((ISplitBox)this.getModel()).getCollapsibleField();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                IFormField field = JsonSplitBox.getFieldIfVisibleGranted((IFormField)value);
                if (field == null) {
                    return null;
                }
                return JsonSplitBox.this.getAdapter(field).getId();
            }
        });
        this.putJsonProperty(new JsonProperty<ISplitBox>("fieldCollapsed", model){

            @Override
            protected Boolean modelValue() {
                return ((ISplitBox)this.getModel()).isFieldCollapsed();
            }
        });
        this.putJsonProperty(new JsonProperty<ISplitBox>("toggleCollapseKeyStroke", model){

            @Override
            protected String modelValue() {
                return ((ISplitBox)this.getModel()).getToggleCollapseKeyStroke();
            }
        });
        this.putJsonProperty(new JsonProperty<ISplitBox>("firstCollapseKeyStroke", model){

            @Override
            protected String modelValue() {
                return ((ISplitBox)this.getModel()).getFirstCollapseKeyStroke();
            }
        });
        this.putJsonProperty(new JsonProperty<ISplitBox>("secondCollapseKeyStroke", model){

            @Override
            protected String modelValue() {
                return ((ISplitBox)this.getModel()).getSecondCollapseKeyStroke();
            }
        });
        this.putJsonProperty(new JsonProperty<ISplitBox>("fieldMinimized", model){

            @Override
            protected Boolean modelValue() {
                return ((ISplitBox)this.getModel()).isFieldMinimized();
            }
        });
        this.putJsonProperty(new JsonProperty<ISplitBox>("minimizeEnabled", model){

            @Override
            protected Boolean modelValue() {
                return ((ISplitBox)this.getModel()).isMinimizeEnabled();
            }
        });
    }

    @Override
    protected void attachChildAdapters() {
        super.attachChildAdapters();
        this.attachAdapter(this.m_firstField);
        this.attachAdapter(this.m_secondField);
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        this.putProperty(json, "splitHorizontal", ((ISplitBox)this.getModel()).isSplitHorizontal());
        this.putAdapterIdProperty(json, "firstField", this.m_firstField);
        this.putAdapterIdProperty(json, "secondField", this.m_secondField);
        return json;
    }

    protected IFormField getFirstField() {
        return this.m_firstField;
    }

    protected IFormField getSecondField() {
        return this.m_secondField;
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_SET_SPLITTER_POSITION.equals(event.getType())) {
            this.handleUiSetSplitterPosition(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiSetSplitterPosition(JsonEvent event) {
        double splitterPosition = event.getData().optDouble("splitterPosition");
        this.addPropertyEventFilterCondition("splitterPosition", splitterPosition);
        ((ISplitBox)this.getModel()).getUIFacade().setSplitterPositionFromUI(splitterPosition);
    }

    @Override
    protected void handleUiPropertyChange(String propertyName, JSONObject data) {
        if ("fieldCollapsed".equals(propertyName)) {
            boolean fieldCollapsed = data.getBoolean(propertyName);
            this.addPropertyEventFilterCondition(propertyName, fieldCollapsed);
            ((ISplitBox)this.getModel()).getUIFacade().setFieldCollapsedFromUI(fieldCollapsed);
        } else if ("fieldMinimized".equals(propertyName)) {
            boolean fieldMinimized = data.getBoolean(propertyName);
            this.addPropertyEventFilterCondition(propertyName, fieldMinimized);
            ((ISplitBox)this.getModel()).getUIFacade().setFieldMinimizedFromUI(fieldMinimized);
        } else if ("minSplitterPosition".equals(propertyName)) {
            Double minSplitterPosition = JsonObjectUtility.optDouble(data, propertyName);
            this.addPropertyEventFilterCondition(propertyName, minSplitterPosition);
            ((ISplitBox)this.getModel()).getUIFacade().setMinSplitterPositionFromUI(minSplitterPosition);
        } else if ("minimizeEnabled".equals(propertyName)) {
            boolean minimizeEnabled = data.getBoolean(propertyName);
            this.addPropertyEventFilterCondition(propertyName, minimizeEnabled);
            ((ISplitBox)this.getModel()).getUIFacade().setMinimizeEnabledFromUI(minimizeEnabled);
        } else {
            super.handleUiPropertyChange(propertyName, data);
        }
    }
}

