/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.tabbox;

import java.util.List;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.DisplayableFormFieldFilter;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfig;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonAdapterPropertyConfigBuilder;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonCompositeField;
import org.json.JSONObject;

public class JsonTabBox<TAB_BOX extends ITabBox>
extends JsonCompositeField<TAB_BOX, IGroupBox> {
    public JsonTabBox(TAB_BOX model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    protected void initJsonProperties(TAB_BOX model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonAdapterProperty<ITabBox>("selectedTab", model, this.getUiSession()){

            protected IGroupBox modelValue() {
                return ((ITabBox)this.getModel()).getSelectedTab();
            }

            @Override
            protected JsonAdapterPropertyConfig createConfig() {
                return new JsonAdapterPropertyConfigBuilder().disposeOnChange(false).filter(new DisplayableFormFieldFilter()).build();
            }
        });
        this.putJsonProperty(new JsonProperty<TAB_BOX>("tabAreaStyle", (ITabBox)model){

            @Override
            protected String modelValue() {
                return ((ITabBox)this.getModel()).getTabAreaStyle();
            }
        });
    }

    @Override
    public String getObjectType() {
        return "TabBox";
    }

    @Override
    protected List<IGroupBox> getModelFields() {
        return ((ITabBox)this.getModel()).getGroupBoxes();
    }

    @Override
    protected String getModelFieldsPropertyName() {
        return "tabItems";
    }

    @Override
    protected void handleUiPropertyChange(String propertyName, JSONObject data) {
        if ("selectedTab".equals(propertyName)) {
            String tabId = data.optString(propertyName);
            IGroupBox selectedTab = this.getGroupBoxForId(tabId);
            this.addPropertyEventFilterCondition(propertyName, selectedTab);
            ((ITabBox)this.getModel()).getUIFacade().setSelectedTabFromUI(selectedTab);
        } else {
            super.handleUiPropertyChange(propertyName, data);
        }
    }

    protected IGroupBox getGroupBoxForId(String tabId) {
        for (IGroupBox gb : ((ITabBox)this.getModel()).getGroupBoxes()) {
            Object adapter = this.getAdapter(gb);
            if (adapter == null || !adapter.getId().equals(tabId)) continue;
            return (IGroupBox)adapter.getModel();
        }
        return null;
    }
}

