/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.tagfield;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallResult;
import org.eclipse.scout.rt.client.ui.form.fields.tagfield.ITagField;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonValueField;
import org.eclipse.scout.rt.ui.html.json.lookup.JsonLookupCallResult;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonTagField
extends JsonValueField<ITagField> {
    public JsonTagField(ITagField model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "TagField";
    }

    @Override
    protected void initJsonProperties(ITagField model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<ITagField>("value", model){

            @Override
            protected Set<String> modelValue() {
                return (Set)((ITagField)this.getModel()).getValue();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                if (value == null) {
                    return new JSONArray();
                }
                return new JSONArray((Collection)((Set)value));
            }
        });
        this.putJsonProperty(new JsonProperty<ITagField>("result", model){

            protected ILookupCallResult<String> modelValue() {
                return ((ITagField)this.getModel()).getResult();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonLookupCallResult.toJson((ILookupCallResult)value);
            }
        });
        this.putJsonProperty(new JsonProperty<ITagField>("maxLength", model){

            @Override
            protected Integer modelValue() {
                return ((ITagField)this.getModel()).getMaxLength();
            }
        });
    }

    @Override
    protected void handleUiAcceptInput(JsonEvent event) {
        JSONObject data = event.getData();
        Object valueFromUi = this.jsonToValue(data.opt("value"));
        this.handleUiValueChange(data);
        Set valueFromModel = (Set)((ITagField)this.getModel()).getValue();
        if (!ObjectUtility.equals((Object)valueFromUi, (Object)valueFromModel)) {
            return;
        }
        this.handleUiDisplayTextChange(data);
    }

    protected void handleUiLookupByText(JsonEvent event) {
        String text = event.getData().optString("text");
        ((ITagField)this.getModel()).getUIFacade().lookupByTextFromUI(text);
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if ("lookupByText".equals(event.getType())) {
            this.handleUiLookupByText(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    @Override
    protected Set<String> jsonToValue(Object jsonValue0) {
        JSONArray jsonValue = (JSONArray)jsonValue0;
        int numTags = jsonValue.length();
        HashSet<String> tags = new HashSet<String>(numTags);
        int i = 0;
        while (i < numTags) {
            tags.add(jsonValue.getString(i));
            ++i;
        }
        return tags;
    }

    @Override
    protected void setValueFromUI(Object value) {
        ((ITagField)this.getModel()).getUIFacade().setValueFromUI((Set)value);
    }
}

