/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.form.fields.wizard;

import java.util.List;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.wizard.IWizardProgressField;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStep;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.InspectorInfo;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.form.fields.JsonFormField;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonWizardProgressField<WIZARD_PROGRESS_FIELD extends IWizardProgressField>
extends JsonFormField<WIZARD_PROGRESS_FIELD> {
    private static final String PROP_ACTIVE_STEP_INDEX = "activeStepIndex";
    private static final String EVENT_DO_STEP_ACTION = "doStepAction";

    public JsonWizardProgressField(WIZARD_PROGRESS_FIELD model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "WizardProgressField";
    }

    @Override
    protected void initJsonProperties(WIZARD_PROGRESS_FIELD model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<WIZARD_PROGRESS_FIELD>("steps", (IWizardProgressField)model){

            @Override
            protected List<IWizardStep<? extends IForm>> modelValue() {
                return ((IWizardProgressField)this.getModel()).getSteps();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                List wizardSteps = (List)value;
                JSONArray jsonSteps = new JSONArray();
                if (wizardSteps != null) {
                    for (IWizardStep wizardStep : wizardSteps) {
                        if (!wizardStep.isVisible()) continue;
                        jsonSteps.put((Object)JsonWizardProgressField.this.wizardStepToJson((IWizardStep<IForm>)wizardStep));
                    }
                }
                return jsonSteps;
            }
        });
        this.putJsonProperty(new JsonProperty<WIZARD_PROGRESS_FIELD>("activeStep", (IWizardProgressField)model){

            protected IWizardStep<? extends IForm> modelValue() {
                return ((IWizardProgressField)this.getModel()).getActiveStep();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                IWizardStep activeWizardStep = (IWizardStep)value;
                return JsonWizardProgressField.this.getStepIndex((IWizardStep<IForm>)activeWizardStep);
            }

            @Override
            public String jsonPropertyName() {
                return JsonWizardProgressField.PROP_ACTIVE_STEP_INDEX;
            }
        });
    }

    protected JSONObject wizardStepToJson(IWizardStep<? extends IForm> wizardStep) {
        JSONObject jsonStep = new JSONObject();
        jsonStep.put("index", (Object)this.getStepIndex(wizardStep));
        jsonStep.put("title", (Object)wizardStep.getTitle());
        jsonStep.put("subTitle", (Object)wizardStep.getSubTitle());
        jsonStep.put("tooltipText", (Object)wizardStep.getTooltipText());
        jsonStep.put("iconId", (Object)BinaryResourceUrlUtility.createIconUrl(wizardStep.getIconId()));
        jsonStep.put("enabled", wizardStep.isEnabled());
        jsonStep.put("actionEnabled", wizardStep.isActionEnabled());
        jsonStep.put("cssClass", (Object)wizardStep.getCssClass());
        jsonStep.put("finished", wizardStep.isFinished());
        ((InspectorInfo)BEANS.get(InspectorInfo.class)).put(this.getUiSession(), jsonStep, wizardStep);
        return jsonStep;
    }

    protected Integer getStepIndex(IWizardStep<? extends IForm> wizardStep) {
        IWizard wizard;
        if (wizardStep != null && (wizard = ((IWizardProgressField)this.getModel()).getWizard()) != null) {
            return wizard.getStepIndex(wizardStep);
        }
        return null;
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_DO_STEP_ACTION.equals(event.getType())) {
            this.handleUiDoStepAction(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiDoStepAction(JsonEvent event) {
        int targetStepIndex = event.getData().optInt("stepIndex", -1);
        ((IWizardProgressField)this.getModel()).getUIFacade().stepActionFromUI(targetStepIndex);
    }
}

