/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.lookup;

import java.util.function.Function;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.MainJsonObjectFactory;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.json.JSONObject;

public class JsonLookupRow<T>
implements IJsonObject {
    private final ILookupRow<T> m_lookupRow;
    private final boolean m_multipleColumns;
    private final Function<T, ?> m_keyMapper;

    public JsonLookupRow(ILookupRow<T> lookupRow) {
        this(lookupRow, false, null);
    }

    public JsonLookupRow(ILookupRow<T> lookupRow, boolean multipleColumns, Function<T, ?> keyMapper) {
        Assertions.assertNotNull(lookupRow);
        this.m_lookupRow = lookupRow;
        this.m_multipleColumns = multipleColumns;
        this.m_keyMapper = keyMapper;
    }

    @Override
    public Object toJson() {
        JSONObject json = new JSONObject();
        json.put("key", this.getKey(this.m_lookupRow.getKey()));
        json.put("text", (Object)this.m_lookupRow.getText());
        if (StringUtility.hasText((CharSequence)this.m_lookupRow.getIconId())) {
            json.put("iconId", (Object)BinaryResourceUrlUtility.createIconUrl(this.m_lookupRow.getIconId()));
        }
        if (StringUtility.hasText((CharSequence)this.m_lookupRow.getTooltipText())) {
            json.put("tooltipText", (Object)this.m_lookupRow.getTooltipText());
        }
        if (StringUtility.hasText((CharSequence)this.m_lookupRow.getBackgroundColor())) {
            json.put("backgroundColor", (Object)this.m_lookupRow.getBackgroundColor());
        }
        if (StringUtility.hasText((CharSequence)this.m_lookupRow.getForegroundColor())) {
            json.put("foregroundColor", (Object)this.m_lookupRow.getForegroundColor());
        }
        if (this.m_lookupRow.getFont() != null) {
            json.put("font", (Object)this.m_lookupRow.getFont().toPattern());
        }
        if (!this.m_lookupRow.isEnabled()) {
            json.put("enabled", this.m_lookupRow.isEnabled());
        }
        if (this.m_lookupRow.getParentKey() != null) {
            json.put("parentKey", this.getKey(this.m_lookupRow.getParentKey()));
        }
        if (!this.m_lookupRow.isActive()) {
            json.put("active", this.m_lookupRow.isActive());
        }
        if (this.m_multipleColumns && this.m_lookupRow.getAdditionalTableRowData() != null) {
            json.put("additionalTableRowData", this.tableRowDataToJson(this.m_lookupRow.getAdditionalTableRowData()));
        }
        if (StringUtility.hasText((CharSequence)this.m_lookupRow.getCssClass())) {
            json.put("cssClass", (Object)this.m_lookupRow.getCssClass());
        }
        return json;
    }

    protected Object tableRowDataToJson(AbstractTableRowData tableRowData) {
        if (tableRowData == null) {
            return null;
        }
        return MainJsonObjectFactory.get().createJsonObject(tableRowData).toJson();
    }

    protected Object getKey(T key) {
        if (key == null) {
            return null;
        }
        return this.m_keyMapper == null ? key : this.m_keyMapper.apply(key);
    }

    public static <T> Object toJson(ILookupRow<T> lookupRow) {
        return JsonLookupRow.toJson(lookupRow, false, null);
    }

    public static <T> Object toJson(ILookupRow<T> lookupRow, boolean multipleColumns, Function<T, ?> keyMapper) {
        if (lookupRow == null) {
            return null;
        }
        return new JsonLookupRow<T>(lookupRow, multipleColumns, keyMapper).toJson();
    }
}

