/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.menu;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineMenuWrapper;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.action.JsonAction;
import org.json.JSONArray;

public class JsonMenu<MENU extends IMenu>
extends JsonAction<MENU> {
    public static final String PROP_SEPARATOR = "separator";
    public static final String PROP_OUTLINE_MENU_WRAPPER = "outlineMenuWrapper";

    public JsonMenu(MENU model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "Menu";
    }

    @Override
    protected void initJsonProperties(MENU model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<MENU>(PROP_SEPARATOR, (IMenu)model){

            @Override
            protected Boolean modelValue() {
                return ((IMenu)this.getModel()).isSeparator();
            }
        });
        this.putJsonProperty(new JsonProperty<MENU>(PROP_OUTLINE_MENU_WRAPPER, (IMenu)model){

            @Override
            protected Boolean modelValue() {
                return this.getModel() instanceof OutlineMenuWrapper;
            }
        });
        this.putJsonProperty(new JsonProperty<MENU>("menuTypes", (IMenu)model){

            @Override
            protected Set<IMenuType> modelValue() {
                return ((IMenu)this.getModel()).getMenuTypes();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                HashSet<String> menuTypes = new HashSet<String>();
                for (IMenuType type : ((IMenu)this.getModel()).getMenuTypes()) {
                    String prefix = type.getClass().getSimpleName().replace("MenuType", "");
                    menuTypes.add(String.valueOf(prefix) + "." + type.toString());
                }
                return new JSONArray(menuTypes);
            }
        });
        this.putJsonProperty(new JsonProperty<MENU>("preventDoubleClick", (IMenu)model){

            @Override
            protected Boolean modelValue() {
                return ((IMenu)this.getModel()).isPreventDoubleClick();
            }
        });
        this.putJsonProperty(new JsonProperty<MENU>("stackable", (IMenu)model){

            @Override
            protected Boolean modelValue() {
                return ((IMenu)this.getModel()).isStackable();
            }
        });
        this.putJsonProperty(new JsonProperty<MENU>("shrinkable", (IMenu)model){

            @Override
            protected Boolean modelValue() {
                return ((IMenu)this.getModel()).isShrinkable();
            }
        });
        this.putJsonProperty(new JsonProperty<MENU>("subMenuVisibility", (IMenu)model){

            @Override
            protected String modelValue() {
                return ((IMenu)this.getModel()).getSubMenuVisibility();
            }
        });
    }
}

