/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.messagebox;

import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxEvent;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxListener;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonWidget;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;

public class JsonMessageBox<MESSAGE_BOX extends IMessageBox>
extends AbstractJsonWidget<MESSAGE_BOX> {
    public static final String EVENT_ACTION = "action";
    private MessageBoxListener m_messageBoxListener;

    public JsonMessageBox(MESSAGE_BOX model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "MessageBox";
    }

    @Override
    protected void initJsonProperties(MESSAGE_BOX model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<IMessageBox>("iconId", model){

            @Override
            protected String modelValue() {
                return ((IMessageBox)this.getModel()).getIconId();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return BinaryResourceUrlUtility.createIconUrl((String)value);
            }
        });
        this.putJsonProperty(new JsonProperty<IMessageBox>("severity", model){

            @Override
            protected Integer modelValue() {
                return ((IMessageBox)this.getModel()).getSeverity();
            }
        });
        this.putJsonProperty(new JsonProperty<IMessageBox>("header", model){

            @Override
            protected String modelValue() {
                return ((IMessageBox)this.getModel()).getHeader();
            }
        });
        this.putJsonProperty(new JsonProperty<IMessageBox>("body", model){

            @Override
            protected String modelValue() {
                return ((IMessageBox)this.getModel()).getBody();
            }
        });
        this.putJsonProperty(new JsonProperty<IMessageBox>("html", model){

            @Override
            protected String modelValue() {
                return ((IMessageBox)this.getModel()).getHtml() == null ? null : ((IMessageBox)this.getModel()).getHtml().toHtml();
            }
        });
        this.putJsonProperty(new JsonProperty<IMessageBox>("hiddenText", model){

            @Override
            protected String modelValue() {
                return ((IMessageBox)this.getModel()).getHiddenText();
            }
        });
        this.putJsonProperty(new JsonProperty<IMessageBox>("copyPasteText", model){

            @Override
            protected String modelValue() {
                return ((IMessageBox)this.getModel()).getCopyPasteText();
            }
        });
        this.putJsonProperty(new JsonProperty<IMessageBox>("yesButtonText", model){

            @Override
            protected String modelValue() {
                return ((IMessageBox)this.getModel()).getYesButtonText();
            }
        });
        this.putJsonProperty(new JsonProperty<IMessageBox>("noButtonText", model){

            @Override
            protected String modelValue() {
                return ((IMessageBox)this.getModel()).getNoButtonText();
            }
        });
        this.putJsonProperty(new JsonProperty<IMessageBox>("cancelButtonText", model){

            @Override
            protected String modelValue() {
                return ((IMessageBox)this.getModel()).getCancelButtonText();
            }
        });
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        if (this.m_messageBoxListener != null) {
            throw new IllegalStateException();
        }
        this.m_messageBoxListener = new P_MessageBoxListener();
        ((IMessageBox)this.getModel()).addMessageBoxListener(this.m_messageBoxListener);
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        if (this.m_messageBoxListener == null) {
            throw new IllegalStateException();
        }
        ((IMessageBox)this.getModel()).removeMessageBoxListener(this.m_messageBoxListener);
        this.m_messageBoxListener = null;
    }

    protected void handleModelMessageBoxChanged(MessageBoxEvent event) {
        switch (event.getType()) {
            case 900: {
                this.handleModelClosed();
            }
        }
    }

    protected void handleModelClosed() {
        this.dispose();
        this.getUiSession().sendDisposeAdapterEvent(this);
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (EVENT_ACTION.equals(event.getType())) {
            this.handleUiAction(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiAction(JsonEvent event) {
        String option = event.getData().getString("option");
        int resultOption = -1;
        if ("yes".equals(option)) {
            resultOption = 0;
        } else if ("no".equals(option)) {
            resultOption = 1;
        } else if ("cancel".equals(option)) {
            resultOption = 2;
        }
        if (resultOption == -1) {
            throw new IllegalStateException("Undefined option" + option);
        }
        ((IMessageBox)this.getModel()).getUIFacade().setResultFromUI(resultOption);
    }

    protected class P_MessageBoxListener
    implements MessageBoxListener {
        protected P_MessageBoxListener() {
        }

        public void messageBoxChanged(MessageBoxEvent event) {
            ModelJobs.assertModelThread();
            JsonMessageBox.this.handleModelMessageBoxChanged(event);
        }
    }
}

