/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.table;

import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.JsonBean;
import org.eclipse.scout.rt.ui.html.json.MainJsonObjectFactory;
import org.eclipse.scout.rt.ui.html.json.table.JsonColumn;

public class JsonBeanColumn<T extends IColumn<?>>
extends JsonColumn<T> {
    public JsonBeanColumn(T model) {
        super(model);
    }

    @Override
    public String getObjectType() {
        return "BeanColumn";
    }

    @Override
    public boolean isValueRequired() {
        return true;
    }

    @Override
    public Object cellValueToJson(Object value) {
        IJsonObject jsonObject = MainJsonObjectFactory.get().createJsonObject(value);
        this.handleBinaryResource(jsonObject);
        return jsonObject.toJson();
    }

    protected void handleBinaryResource(IJsonObject jsonObject) {
        if (jsonObject instanceof JsonBean) {
            ((JsonBean)jsonObject).setBinaryResourceMediator(this.getJsonTable().getBinaryResourceMediator());
        }
    }
}

