/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.table;

import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.userfilter.ColumnUserFilterState;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.InspectorInfo;
import org.eclipse.scout.rt.ui.html.json.JsonAdapterUtility;
import org.eclipse.scout.rt.ui.html.json.basic.cell.ICellValueReader;
import org.eclipse.scout.rt.ui.html.json.basic.cell.JsonCell;
import org.eclipse.scout.rt.ui.html.json.table.JsonTable;
import org.eclipse.scout.rt.ui.html.json.table.TableCellValueReader;
import org.eclipse.scout.rt.ui.html.json.table.userfilter.JsonTextColumnUserFilter;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.json.JSONObject;

public class JsonColumn<T extends IColumn<?>>
implements IJsonObject {
    public static final String OBJECT_TYPE = "Column";
    private String m_id;
    private final T m_column;
    private JsonTable<?> m_jsonTable;
    private int m_indexOffset;
    private static final String PROP_INITIAL_ALWAYS_INCLUDE_SORT_AT_BEGIN = "initialAlwaysIncludeSortAtBegin";
    private static final String PROP_INITIAL_ALWAYS_INCLUDE_SORT_AT_END = "initialAlwaysIncludeSortAtEnd";
    private static final String PROP_REMOVABLE = "removable";
    private static final String PROP_MODIFIABLE = "modifiable";
    private static final String PROP_COMPACTED = "compacted";

    public JsonColumn(T model) {
        this.m_column = model;
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    protected String getObjectTypeVariant() {
        return JsonAdapterUtility.getObjectType(this.getObjectType(), this.m_column);
    }

    public void setColumnIndexOffset(int indexOffset) {
        this.m_indexOffset = indexOffset;
    }

    public boolean isValueRequired() {
        return false;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.getId());
        json.put("objectType", (Object)this.getObjectTypeVariant());
        json.put("index", this.getColumn().getColumnIndex() - this.m_indexOffset);
        json.put("text", (Object)this.getColumn().getHeaderCell().getText());
        json.put("width", this.getColumn().getWidth());
        json.put("minWidth", this.getColumn().getMinWidth());
        json.put("autoOptimizeMaxWidth", this.getColumn().getAutoOptimizeMaxWidth());
        if (this.getColumn().getInitialWidth() != this.getColumn().getWidth()) {
            json.put("initialWidth", this.getColumn().getInitialWidth());
        }
        json.put("summary", this.getColumn().isSummary());
        json.put("horizontalAlignment", this.getColumn().getHorizontalAlignment());
        if (this.getColumn().isSortActive()) {
            json.put("sortActive", true);
            json.put("sortAscending", this.getColumn().isSortAscending());
            json.put("sortIndex", this.getColumn().getSortIndex());
            json.put("grouped", this.getColumn().isGroupingActive());
        }
        if (this.getColumn().getTable().getCheckableColumn() == this.getColumn()) {
            json.put("checkable", true);
        }
        json.put("fixedWidth", this.getColumn().isFixedWidth());
        json.put("fixedPosition", this.getColumn().isFixedPosition());
        json.put("autoOptimizeWidth", this.getColumn().isAutoOptimizeWidth());
        json.put("editable", this.getColumn().isEditable());
        json.put("mandatory", this.getColumn().isMandatory());
        json.put("htmlEnabled", this.getColumn().isHtmlEnabled());
        json.put("cssClass", (Object)this.getColumn().getCssClass());
        json.put("headerCssClass", (Object)this.getColumn().getHeaderCell().getCssClass());
        json.put("headerHtmlEnabled", this.getColumn().getHeaderCell().isHtmlEnabled());
        json.put("headerMenuEnabled", this.getColumn().getHeaderCell().isMenuEnabled());
        json.put("headerBackgroundColor", (Object)this.getColumn().getHeaderCell().getBackgroundColor());
        json.put("headerForegroundColor", (Object)this.getColumn().getHeaderCell().getForegroundColor());
        json.put("headerFont", this.getColumn().getHeaderCell().getFont() != null ? this.getColumn().getHeaderCell().getFont().toPattern() : null);
        json.put("headerTooltipText", (Object)this.getColumn().getHeaderCell().getTooltipText());
        json.put("headerTooltipHtmlEnabled", this.getColumn().getHeaderCell().isTooltipHtmlEnabled());
        json.put("headerIconId", (Object)BinaryResourceUrlUtility.createIconUrl(this.getColumn().getHeaderCell().getIconId()));
        ((InspectorInfo)BEANS.get(InspectorInfo.class)).put(this.getUiSession(), json, this.getColumn());
        json.put("uiSortPossible", this.getColumn().isUiSortPossible());
        json.put(PROP_INITIAL_ALWAYS_INCLUDE_SORT_AT_BEGIN, this.getColumn().isInitialAlwaysIncludeSortAtBegin());
        json.put(PROP_INITIAL_ALWAYS_INCLUDE_SORT_AT_END, this.getColumn().isInitialAlwaysIncludeSortAtEnd());
        json.put(PROP_REMOVABLE, this.getColumn().isRemovable());
        json.put(PROP_MODIFIABLE, this.getColumn().isModifiable());
        json.put("nodeColumnCandidate", this.getColumn().isNodeColumnCandidate());
        json.put(PROP_COMPACTED, this.getColumn().isCompacted());
        return json;
    }

    protected ColumnUserFilterState createFilterStateFromJson(JSONObject json) {
        return new JsonTextColumnUserFilter(null).createFilterStateFromJson((IColumn<?>)this.getColumn(), json);
    }

    public Object cellValueToJson(Object value) {
        if (this.isValueRequired()) {
            return value;
        }
        return null;
    }

    protected ICellValueReader createCellValueReader(ICell cell) {
        return new TableCellValueReader(this, cell);
    }

    public JsonCell createJsonCell(ICell cell, IJsonAdapter<?> parentAdapter) {
        return new JsonCell(cell, parentAdapter, this.createCellValueReader(cell));
    }

    public T getColumn() {
        return this.m_column;
    }

    public IUiSession getUiSession() {
        return this.getJsonTable().getUiSession();
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public void setJsonTable(JsonTable<?> jsonTable) {
        this.m_jsonTable = jsonTable;
    }

    public JsonTable<?> getJsonTable() {
        return this.m_jsonTable;
    }
}

