/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.ui.html.json.AbstractEventFilter;
import org.eclipse.scout.rt.ui.html.json.table.JsonTable;
import org.eclipse.scout.rt.ui.html.json.table.TableEventFilterCondition;

public class TableEventFilter
extends AbstractEventFilter<TableEvent, TableEventFilterCondition> {
    private final JsonTable<? extends ITable> m_jsonTable;

    public TableEventFilter(JsonTable<? extends ITable> jsonTable) {
        this.m_jsonTable = jsonTable;
    }

    @Override
    public TableEvent filter(TableEvent event) {
        for (TableEventFilterCondition condition : this.getConditions()) {
            if (condition.getType() != event.getType()) continue;
            if (condition.checkRows()) {
                ArrayList rows = new ArrayList(event.getRows());
                rows.removeAll(condition.getRows());
                if (rows.isEmpty()) {
                    return null;
                }
                TableEvent newEvent = new TableEvent((ITable)this.m_jsonTable.getModel(), event.getType(), rows);
                return newEvent;
            }
            if (condition.checkCheckedRows()) {
                List rows = new ArrayList(event.getRows());
                ArrayList<ITableRow> checkedRows = new ArrayList<ITableRow>();
                ArrayList<ITableRow> uncheckedRows = new ArrayList<ITableRow>();
                for (ITableRow row : rows) {
                    if (row.isChecked()) {
                        checkedRows.add(row);
                        continue;
                    }
                    uncheckedRows.add(row);
                }
                if (CollectionUtility.equalsCollection(checkedRows, condition.getCheckedRows()) && CollectionUtility.equalsCollection(uncheckedRows, condition.getUncheckedRows())) {
                    return null;
                }
                checkedRows.removeAll(condition.getCheckedRows());
                uncheckedRows.removeAll(condition.getUncheckedRows());
                rows = CollectionUtility.combine((Collection[])new Collection[]{checkedRows, uncheckedRows});
                TableEvent newEvent = new TableEvent((ITable)this.m_jsonTable.getModel(), event.getType(), rows);
                return newEvent;
            }
            if (condition.checkColumns()) {
                if (CollectionUtility.equalsCollection(this.m_jsonTable.getColumnsInViewOrder(), condition.getColumns())) {
                    return null;
                }
                return event;
            }
            if (condition.checkUserFilter()) {
                if (condition.getUserFilter().equals(event.getUserFilter())) {
                    return null;
                }
                return event;
            }
            return null;
        }
        return event;
    }
}

