/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.table.userfilter;

import java.util.Date;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.userfilter.ColumnUserFilterState;
import org.eclipse.scout.rt.client.ui.basic.table.userfilter.DateColumnUserFilterState;
import org.eclipse.scout.rt.ui.html.json.JsonDate;
import org.eclipse.scout.rt.ui.html.json.table.userfilter.JsonColumnUserFilter;
import org.json.JSONObject;

public class JsonDateColumnUserFilter
extends JsonColumnUserFilter<DateColumnUserFilterState> {
    public JsonDateColumnUserFilter(DateColumnUserFilterState filterState) {
        super(filterState);
    }

    @Override
    public String getObjectType() {
        return "DateColumnUserFilter";
    }

    protected String dateToJson(Date date) {
        return JsonDate.format(date, "yyyy-MM-dd", false);
    }

    protected Date toDate(String dateString) {
        return JsonDate.parse(dateString, "yyyy-MM-dd");
    }

    @Override
    public ColumnUserFilterState createFilterStateFromJson(IColumn<?> column, JSONObject json) {
        DateColumnUserFilterState filterState = new DateColumnUserFilterState(column);
        filterState.setSelectedValues(this.createSelectedValuesFromJson(json));
        filterState.setDateFrom(this.toDate(json.optString("dateFrom")));
        filterState.setDateTo(this.toDate(json.optString("dateTo")));
        return filterState;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        json.put("dateFrom", (Object)this.dateToJson(((DateColumnUserFilterState)this.getFilterState()).getDateFrom()));
        json.put("dateTo", (Object)this.dateToJson(((DateColumnUserFilterState)this.getFilterState()).getDateTo()));
        return json;
    }
}

