/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.tile;

import org.eclipse.scout.rt.client.ui.tile.IBeanTile;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.JsonBean;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonEventType;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.MainJsonObjectFactory;
import org.eclipse.scout.rt.ui.html.json.tile.JsonTile;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceHolder;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceMediator;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceProvider;

public class JsonBeanTile<BEAN_TILE extends IBeanTile<?>>
extends JsonTile<BEAN_TILE>
implements IBinaryResourceProvider {
    private final BinaryResourceMediator m_binaryResourceMediator = this.createBinaryResourceMediator();

    public JsonBeanTile(BEAN_TILE model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    protected BinaryResourceMediator createBinaryResourceMediator() {
        return new BinaryResourceMediator(this);
    }

    @Override
    public String getObjectType() {
        return "BeanTile";
    }

    @Override
    protected void initJsonProperties(BEAN_TILE model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<BEAN_TILE>("bean", (IBeanTile)model){

            @Override
            protected Object modelValue() {
                return ((IBeanTile)this.getModel()).getBean();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return JsonBeanTile.this.beanToJson(value);
            }
        });
    }

    protected Object beanToJson(Object value) {
        IJsonObject jsonObject = MainJsonObjectFactory.get().createJsonObject(value);
        JsonBean jsonBean = (JsonBean)jsonObject;
        jsonBean.setBinaryResourceMediator(this.m_binaryResourceMediator);
        return jsonObject.toJson();
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (JsonEventType.APP_LINK_ACTION.matches(event.getType())) {
            this.handleUiAppLinkAction(event);
        } else {
            super.handleUiEvent(event);
        }
    }

    protected void handleUiAppLinkAction(JsonEvent event) {
        String ref = event.getData().optString("ref", null);
        ((IBeanTile)this.getModel()).getUIFacade().fireAppLinkActionFromUI(ref);
    }

    @Override
    public BinaryResourceHolder provideBinaryResource(String filename) {
        return this.m_binaryResourceMediator.getBinaryResourceHolder(filename);
    }
}

