/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.tile;

import org.eclipse.scout.rt.client.ui.tile.IHtmlTile;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.tile.JsonTile;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceHolder;
import org.eclipse.scout.rt.ui.html.res.BinaryResourceUrlUtility;
import org.eclipse.scout.rt.ui.html.res.IBinaryResourceProvider;

public class JsonHtmlTile<T extends IHtmlTile>
extends JsonTile<T>
implements IBinaryResourceProvider {
    public JsonHtmlTile(T model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "HtmlTile";
    }

    @Override
    protected void initJsonProperties(T model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<T>("content", (IHtmlTile)model){

            @Override
            protected String modelValue() {
                return ((IHtmlTile)this.getModel()).getContent();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return BinaryResourceUrlUtility.replaceImageUrls(JsonHtmlTile.this, (String)value);
            }
        });
    }

    @Override
    public BinaryResourceHolder provideBinaryResource(String filename) {
        BinaryResource attachment = ((IHtmlTile)this.getModel()).getAttachment(filename);
        return attachment == null ? null : new BinaryResourceHolder(attachment);
    }
}

