/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.ui.html.json.AbstractEventFilter;
import org.eclipse.scout.rt.ui.html.json.tree.JsonTree;
import org.eclipse.scout.rt.ui.html.json.tree.TreeEventFilterCondition;

public class TreeEventFilter
extends AbstractEventFilter<TreeEvent, TreeEventFilterCondition> {
    private final JsonTree<? extends ITree> m_jsonTree;

    public TreeEventFilter(JsonTree<? extends ITree> jsonTree) {
        this.m_jsonTree = jsonTree;
    }

    @Override
    public TreeEvent filter(TreeEvent event) {
        for (TreeEventFilterCondition condition : this.getConditions()) {
            if (condition.getType() != event.getType()) continue;
            if (condition.checkNodes()) {
                ArrayList nodes = new ArrayList(event.getNodes());
                nodes.removeAll(condition.getNodes());
                if (nodes.isEmpty()) {
                    return null;
                }
                return new TreeEvent((ITree)this.m_jsonTree.getModel(), event.getType(), event.getCommonParentNode(), nodes);
            }
            if (condition.checkCheckedNodes()) {
                List nodes = new ArrayList(event.getNodes());
                ArrayList<ITreeNode> checkedNodes = new ArrayList<ITreeNode>();
                ArrayList<ITreeNode> uncheckedNodes = new ArrayList<ITreeNode>();
                for (ITreeNode node : nodes) {
                    if (node.isChecked()) {
                        checkedNodes.add(node);
                        continue;
                    }
                    uncheckedNodes.add(node);
                }
                if (CollectionUtility.equalsCollection(checkedNodes, condition.getCheckedNodes()) && CollectionUtility.equalsCollection(uncheckedNodes, condition.getUncheckedNodes())) {
                    return null;
                }
                checkedNodes.removeAll(condition.getCheckedNodes());
                uncheckedNodes.removeAll(condition.getUncheckedNodes());
                nodes = CollectionUtility.combine((Collection[])new Collection[]{checkedNodes, uncheckedNodes});
                TreeEvent newEvent = new TreeEvent((ITree)this.m_jsonTree.getModel(), event.getType(), event.getCommonParentNode(), nodes);
                return newEvent;
            }
            return null;
        }
        return event;
    }
}

